/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.ImplicitGrantSettings;
import com.microsoft.graph.models.RedirectUriSettings;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class WebApplication
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public WebApplication() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static WebApplication createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new WebApplication();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(6);
        deserializerMap.put("homePageUrl", n -> this.setHomePageUrl(n.getStringValue()));
        deserializerMap.put("implicitGrantSettings", n -> this.setImplicitGrantSettings((ImplicitGrantSettings)n.getObjectValue(ImplicitGrantSettings::createFromDiscriminatorValue)));
        deserializerMap.put("logoutUrl", n -> this.setLogoutUrl(n.getStringValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("redirectUris", n -> this.setRedirectUris(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("redirectUriSettings", n -> this.setRedirectUriSettings(n.getCollectionOfObjectValues(RedirectUriSettings::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public String getHomePageUrl() {
        return (String)this.backingStore.get("homePageUrl");
    }

    @Nullable
    public ImplicitGrantSettings getImplicitGrantSettings() {
        return (ImplicitGrantSettings)this.backingStore.get("implicitGrantSettings");
    }

    @Nullable
    public String getLogoutUrl() {
        return (String)this.backingStore.get("logoutUrl");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public List<String> getRedirectUris() {
        return (List)this.backingStore.get("redirectUris");
    }

    @Nullable
    public List<RedirectUriSettings> getRedirectUriSettings() {
        return (List)this.backingStore.get("redirectUriSettings");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeStringValue("homePageUrl", this.getHomePageUrl());
        writer.writeObjectValue("implicitGrantSettings", (Parsable)this.getImplicitGrantSettings(), new Parsable[0]);
        writer.writeStringValue("logoutUrl", this.getLogoutUrl());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeCollectionOfPrimitiveValues("redirectUris", this.getRedirectUris());
        writer.writeCollectionOfObjectValues("redirectUriSettings", this.getRedirectUriSettings());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setHomePageUrl(@Nullable String value) {
        this.backingStore.set("homePageUrl", (Object)value);
    }

    public void setImplicitGrantSettings(@Nullable ImplicitGrantSettings value) {
        this.backingStore.set("implicitGrantSettings", (Object)value);
    }

    public void setLogoutUrl(@Nullable String value) {
        this.backingStore.set("logoutUrl", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setRedirectUris(@Nullable List<String> value) {
        this.backingStore.set("redirectUris", value);
    }

    public void setRedirectUriSettings(@Nullable List<RedirectUriSettings> value) {
        this.backingStore.set("redirectUriSettings", value);
    }
}

