/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.SynchronizationError;
import com.microsoft.graph.models.SynchronizationTaskExecutionResult;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class SynchronizationTaskExecution
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public SynchronizationTaskExecution() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static SynchronizationTaskExecution createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new SynchronizationTaskExecution();
    }

    @Nullable
    public String getActivityIdentifier() {
        return (String)this.backingStore.get("activityIdentifier");
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public Long getCountEntitled() {
        return (Long)this.backingStore.get("countEntitled");
    }

    @Nullable
    public Long getCountEntitledForProvisioning() {
        return (Long)this.backingStore.get("countEntitledForProvisioning");
    }

    @Nullable
    public Long getCountEscrowed() {
        return (Long)this.backingStore.get("countEscrowed");
    }

    @Nullable
    public Long getCountEscrowedRaw() {
        return (Long)this.backingStore.get("countEscrowedRaw");
    }

    @Nullable
    public Long getCountExported() {
        return (Long)this.backingStore.get("countExported");
    }

    @Nullable
    public Long getCountExports() {
        return (Long)this.backingStore.get("countExports");
    }

    @Nullable
    public Long getCountImported() {
        return (Long)this.backingStore.get("countImported");
    }

    @Nullable
    public Long getCountImportedDeltas() {
        return (Long)this.backingStore.get("countImportedDeltas");
    }

    @Nullable
    public Long getCountImportedReferenceDeltas() {
        return (Long)this.backingStore.get("countImportedReferenceDeltas");
    }

    @Nullable
    public SynchronizationError getError() {
        return (SynchronizationError)this.backingStore.get("error");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(15);
        deserializerMap.put("activityIdentifier", n -> this.setActivityIdentifier(n.getStringValue()));
        deserializerMap.put("countEntitled", n -> this.setCountEntitled(n.getLongValue()));
        deserializerMap.put("countEntitledForProvisioning", n -> this.setCountEntitledForProvisioning(n.getLongValue()));
        deserializerMap.put("countEscrowed", n -> this.setCountEscrowed(n.getLongValue()));
        deserializerMap.put("countEscrowedRaw", n -> this.setCountEscrowedRaw(n.getLongValue()));
        deserializerMap.put("countExported", n -> this.setCountExported(n.getLongValue()));
        deserializerMap.put("countExports", n -> this.setCountExports(n.getLongValue()));
        deserializerMap.put("countImported", n -> this.setCountImported(n.getLongValue()));
        deserializerMap.put("countImportedDeltas", n -> this.setCountImportedDeltas(n.getLongValue()));
        deserializerMap.put("countImportedReferenceDeltas", n -> this.setCountImportedReferenceDeltas(n.getLongValue()));
        deserializerMap.put("error", n -> this.setError((SynchronizationError)n.getObjectValue(SynchronizationError::createFromDiscriminatorValue)));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("state", n -> this.setState((SynchronizationTaskExecutionResult)n.getEnumValue(SynchronizationTaskExecutionResult::forValue)));
        deserializerMap.put("timeBegan", n -> this.setTimeBegan(n.getOffsetDateTimeValue()));
        deserializerMap.put("timeEnded", n -> this.setTimeEnded(n.getOffsetDateTimeValue()));
        return deserializerMap;
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public SynchronizationTaskExecutionResult getState() {
        return (SynchronizationTaskExecutionResult)((Object)this.backingStore.get("state"));
    }

    @Nullable
    public OffsetDateTime getTimeBegan() {
        return (OffsetDateTime)this.backingStore.get("timeBegan");
    }

    @Nullable
    public OffsetDateTime getTimeEnded() {
        return (OffsetDateTime)this.backingStore.get("timeEnded");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeStringValue("activityIdentifier", this.getActivityIdentifier());
        writer.writeLongValue("countEntitled", this.getCountEntitled());
        writer.writeLongValue("countEntitledForProvisioning", this.getCountEntitledForProvisioning());
        writer.writeLongValue("countEscrowed", this.getCountEscrowed());
        writer.writeLongValue("countEscrowedRaw", this.getCountEscrowedRaw());
        writer.writeLongValue("countExported", this.getCountExported());
        writer.writeLongValue("countExports", this.getCountExports());
        writer.writeLongValue("countImported", this.getCountImported());
        writer.writeLongValue("countImportedDeltas", this.getCountImportedDeltas());
        writer.writeLongValue("countImportedReferenceDeltas", this.getCountImportedReferenceDeltas());
        writer.writeObjectValue("error", (Parsable)this.getError(), new Parsable[0]);
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeEnumValue("state", (Enum)this.getState());
        writer.writeOffsetDateTimeValue("timeBegan", this.getTimeBegan());
        writer.writeOffsetDateTimeValue("timeEnded", this.getTimeEnded());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setActivityIdentifier(@Nullable String value) {
        this.backingStore.set("activityIdentifier", (Object)value);
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setCountEntitled(@Nullable Long value) {
        this.backingStore.set("countEntitled", (Object)value);
    }

    public void setCountEntitledForProvisioning(@Nullable Long value) {
        this.backingStore.set("countEntitledForProvisioning", (Object)value);
    }

    public void setCountEscrowed(@Nullable Long value) {
        this.backingStore.set("countEscrowed", (Object)value);
    }

    public void setCountEscrowedRaw(@Nullable Long value) {
        this.backingStore.set("countEscrowedRaw", (Object)value);
    }

    public void setCountExported(@Nullable Long value) {
        this.backingStore.set("countExported", (Object)value);
    }

    public void setCountExports(@Nullable Long value) {
        this.backingStore.set("countExports", (Object)value);
    }

    public void setCountImported(@Nullable Long value) {
        this.backingStore.set("countImported", (Object)value);
    }

    public void setCountImportedDeltas(@Nullable Long value) {
        this.backingStore.set("countImportedDeltas", (Object)value);
    }

    public void setCountImportedReferenceDeltas(@Nullable Long value) {
        this.backingStore.set("countImportedReferenceDeltas", (Object)value);
    }

    public void setError(@Nullable SynchronizationError value) {
        this.backingStore.set("error", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setState(@Nullable SynchronizationTaskExecutionResult value) {
        this.backingStore.set("state", (Object)value);
    }

    public void setTimeBegan(@Nullable OffsetDateTime value) {
        this.backingStore.set("timeBegan", (Object)value);
    }

    public void setTimeEnded(@Nullable OffsetDateTime value) {
        this.backingStore.set("timeEnded", (Object)value);
    }
}

