/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.ServiceProvisioningXmlError;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class ServiceProvisioningError
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public ServiceProvisioningError() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static ServiceProvisioningError createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.serviceProvisioningXmlError": {
                    return new ServiceProvisioningXmlError();
                }
            }
        }
        return new ServiceProvisioningError();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public OffsetDateTime getCreatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("createdDateTime");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(4);
        deserializerMap.put("createdDateTime", n -> this.setCreatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("isResolved", n -> this.setIsResolved(n.getBooleanValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("serviceInstance", n -> this.setServiceInstance(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public Boolean getIsResolved() {
        return (Boolean)this.backingStore.get("isResolved");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public String getServiceInstance() {
        return (String)this.backingStore.get("serviceInstance");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeOffsetDateTimeValue("createdDateTime", this.getCreatedDateTime());
        writer.writeBooleanValue("isResolved", this.getIsResolved());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeStringValue("serviceInstance", this.getServiceInstance());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setCreatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("createdDateTime", (Object)value);
    }

    public void setIsResolved(@Nullable Boolean value) {
        this.backingStore.set("isResolved", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setServiceInstance(@Nullable String value) {
        this.backingStore.set("serviceInstance", (Object)value);
    }
}

