/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.AuditActivityInitiator;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.KeyValue;
import com.microsoft.graph.models.OperationResult;
import com.microsoft.graph.models.TargetResource;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class DirectoryAudit
extends Entity
implements Parsable {
    @Nonnull
    public static DirectoryAudit createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new DirectoryAudit();
    }

    @Nullable
    public OffsetDateTime getActivityDateTime() {
        return (OffsetDateTime)this.backingStore.get("activityDateTime");
    }

    @Nullable
    public String getActivityDisplayName() {
        return (String)this.backingStore.get("activityDisplayName");
    }

    @Nullable
    public List<KeyValue> getAdditionalDetails() {
        return (List)this.backingStore.get("additionalDetails");
    }

    @Nullable
    public String getCategory() {
        return (String)this.backingStore.get("category");
    }

    @Nullable
    public String getCorrelationId() {
        return (String)this.backingStore.get("correlationId");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("activityDateTime", n -> this.setActivityDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("activityDisplayName", n -> this.setActivityDisplayName(n.getStringValue()));
        deserializerMap.put("additionalDetails", n -> this.setAdditionalDetails(n.getCollectionOfObjectValues(KeyValue::createFromDiscriminatorValue)));
        deserializerMap.put("category", n -> this.setCategory(n.getStringValue()));
        deserializerMap.put("correlationId", n -> this.setCorrelationId(n.getStringValue()));
        deserializerMap.put("initiatedBy", n -> this.setInitiatedBy((AuditActivityInitiator)n.getObjectValue(AuditActivityInitiator::createFromDiscriminatorValue)));
        deserializerMap.put("loggedByService", n -> this.setLoggedByService(n.getStringValue()));
        deserializerMap.put("operationType", n -> this.setOperationType(n.getStringValue()));
        deserializerMap.put("result", n -> this.setResult((OperationResult)n.getEnumValue(OperationResult::forValue)));
        deserializerMap.put("resultReason", n -> this.setResultReason(n.getStringValue()));
        deserializerMap.put("targetResources", n -> this.setTargetResources(n.getCollectionOfObjectValues(TargetResource::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public AuditActivityInitiator getInitiatedBy() {
        return (AuditActivityInitiator)this.backingStore.get("initiatedBy");
    }

    @Nullable
    public String getLoggedByService() {
        return (String)this.backingStore.get("loggedByService");
    }

    @Nullable
    public String getOperationType() {
        return (String)this.backingStore.get("operationType");
    }

    @Nullable
    public OperationResult getResult() {
        return (OperationResult)((Object)this.backingStore.get("result"));
    }

    @Nullable
    public String getResultReason() {
        return (String)this.backingStore.get("resultReason");
    }

    @Nullable
    public List<TargetResource> getTargetResources() {
        return (List)this.backingStore.get("targetResources");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeOffsetDateTimeValue("activityDateTime", this.getActivityDateTime());
        writer.writeStringValue("activityDisplayName", this.getActivityDisplayName());
        writer.writeCollectionOfObjectValues("additionalDetails", this.getAdditionalDetails());
        writer.writeStringValue("category", this.getCategory());
        writer.writeStringValue("correlationId", this.getCorrelationId());
        writer.writeObjectValue("initiatedBy", (Parsable)this.getInitiatedBy(), new Parsable[0]);
        writer.writeStringValue("loggedByService", this.getLoggedByService());
        writer.writeStringValue("operationType", this.getOperationType());
        writer.writeEnumValue("result", (Enum)this.getResult());
        writer.writeStringValue("resultReason", this.getResultReason());
        writer.writeCollectionOfObjectValues("targetResources", this.getTargetResources());
    }

    public void setActivityDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("activityDateTime", (Object)value);
    }

    public void setActivityDisplayName(@Nullable String value) {
        this.backingStore.set("activityDisplayName", (Object)value);
    }

    public void setAdditionalDetails(@Nullable List<KeyValue> value) {
        this.backingStore.set("additionalDetails", value);
    }

    public void setCategory(@Nullable String value) {
        this.backingStore.set("category", (Object)value);
    }

    public void setCorrelationId(@Nullable String value) {
        this.backingStore.set("correlationId", (Object)value);
    }

    public void setInitiatedBy(@Nullable AuditActivityInitiator value) {
        this.backingStore.set("initiatedBy", (Object)value);
    }

    public void setLoggedByService(@Nullable String value) {
        this.backingStore.set("loggedByService", (Object)value);
    }

    public void setOperationType(@Nullable String value) {
        this.backingStore.set("operationType", (Object)value);
    }

    public void setResult(@Nullable OperationResult value) {
        this.backingStore.set("result", (Object)value);
    }

    public void setResultReason(@Nullable String value) {
        this.backingStore.set("resultReason", (Object)value);
    }

    public void setTargetResources(@Nullable List<TargetResource> value) {
        this.backingStore.set("targetResources", value);
    }
}

