/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.CloudPcDomainJoinType;
import com.microsoft.graph.models.CloudPcRegionGroup;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class CloudPcDomainJoinConfiguration
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public CloudPcDomainJoinConfiguration() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static CloudPcDomainJoinConfiguration createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new CloudPcDomainJoinConfiguration();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public CloudPcDomainJoinType getDomainJoinType() {
        return (CloudPcDomainJoinType)((Object)this.backingStore.get("domainJoinType"));
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(5);
        deserializerMap.put("domainJoinType", n -> this.setDomainJoinType((CloudPcDomainJoinType)n.getEnumValue(CloudPcDomainJoinType::forValue)));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("onPremisesConnectionId", n -> this.setOnPremisesConnectionId(n.getStringValue()));
        deserializerMap.put("regionGroup", n -> this.setRegionGroup((CloudPcRegionGroup)n.getEnumValue(CloudPcRegionGroup::forValue)));
        deserializerMap.put("regionName", n -> this.setRegionName(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public String getOnPremisesConnectionId() {
        return (String)this.backingStore.get("onPremisesConnectionId");
    }

    @Nullable
    public CloudPcRegionGroup getRegionGroup() {
        return (CloudPcRegionGroup)((Object)this.backingStore.get("regionGroup"));
    }

    @Nullable
    public String getRegionName() {
        return (String)this.backingStore.get("regionName");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeEnumValue("domainJoinType", (Enum)this.getDomainJoinType());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeStringValue("onPremisesConnectionId", this.getOnPremisesConnectionId());
        writer.writeEnumValue("regionGroup", (Enum)this.getRegionGroup());
        writer.writeStringValue("regionName", this.getRegionName());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setDomainJoinType(@Nullable CloudPcDomainJoinType value) {
        this.backingStore.set("domainJoinType", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setOnPremisesConnectionId(@Nullable String value) {
        this.backingStore.set("onPremisesConnectionId", (Object)value);
    }

    public void setRegionGroup(@Nullable CloudPcRegionGroup value) {
        this.backingStore.set("regionGroup", (Object)value);
    }

    public void setRegionName(@Nullable String value) {
        this.backingStore.set("regionName", (Object)value);
    }
}

