/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.education;

import com.microsoft.graph.education.classes.ClassesRequestBuilder;
import com.microsoft.graph.education.me.MeRequestBuilder;
import com.microsoft.graph.education.schools.SchoolsRequestBuilder;
import com.microsoft.graph.education.users.UsersRequestBuilder;
import com.microsoft.graph.models.EducationRoot;
import com.microsoft.graph.models.odataerrors.ODataError;
import com.microsoft.kiota.BaseRequestBuilder;
import com.microsoft.kiota.BaseRequestConfiguration;
import com.microsoft.kiota.HttpMethod;
import com.microsoft.kiota.QueryParameters;
import com.microsoft.kiota.RequestAdapter;
import com.microsoft.kiota.RequestInformation;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParsableFactory;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class EducationRequestBuilder
extends BaseRequestBuilder {
    @Nonnull
    public ClassesRequestBuilder classes() {
        return new ClassesRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public MeRequestBuilder me() {
        return new MeRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public SchoolsRequestBuilder schools() {
        return new SchoolsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public UsersRequestBuilder users() {
        return new UsersRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    public EducationRequestBuilder(@Nonnull HashMap<String, Object> pathParameters, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/education{?%24expand,%24select}", pathParameters);
    }

    public EducationRequestBuilder(@Nonnull String rawUrl, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/education{?%24expand,%24select}", rawUrl);
    }

    @Nullable
    public EducationRoot get() {
        return this.get(null);
    }

    @Nullable
    public EducationRoot get(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = this.toGetRequestInformation(requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("XXX", ODataError::createFromDiscriminatorValue);
        return (EducationRoot)this.requestAdapter.send(requestInfo, errorMapping, EducationRoot::createFromDiscriminatorValue);
    }

    @Nullable
    public EducationRoot patch(@Nonnull EducationRoot body) {
        return this.patch(body, null);
    }

    @Nullable
    public EducationRoot patch(@Nonnull EducationRoot body, @Nullable Consumer<PatchRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = this.toPatchRequestInformation(body, requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("XXX", ODataError::createFromDiscriminatorValue);
        return (EducationRoot)this.requestAdapter.send(requestInfo, errorMapping, EducationRoot::createFromDiscriminatorValue);
    }

    @Nonnull
    public RequestInformation toGetRequestInformation() {
        return this.toGetRequestInformation(null);
    }

    @Nonnull
    public RequestInformation toGetRequestInformation(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = new RequestInformation(HttpMethod.GET, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new GetRequestConfiguration(), x -> x.queryParameters);
        requestInfo.headers.tryAdd("Accept", "application/json");
        return requestInfo;
    }

    @Nonnull
    public RequestInformation toPatchRequestInformation(@Nonnull EducationRoot body) {
        return this.toPatchRequestInformation(body, null);
    }

    @Nonnull
    public RequestInformation toPatchRequestInformation(@Nonnull EducationRoot body, @Nullable Consumer<PatchRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = new RequestInformation(HttpMethod.PATCH, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new PatchRequestConfiguration());
        requestInfo.headers.tryAdd("Accept", "application/json");
        requestInfo.setContentFromParsable(this.requestAdapter, "application/json", (Parsable)body);
        return requestInfo;
    }

    @Nonnull
    public EducationRequestBuilder withUrl(@Nonnull String rawUrl) {
        Objects.requireNonNull(rawUrl);
        return new EducationRequestBuilder(rawUrl, this.requestAdapter);
    }

    public class PatchRequestConfiguration
    extends BaseRequestConfiguration {
    }

    public class GetRequestConfiguration
    extends BaseRequestConfiguration {
        @Nullable
        public GetQueryParameters queryParameters;

        public GetRequestConfiguration() {
            this.queryParameters = new GetQueryParameters();
        }
    }

    public class GetQueryParameters
    implements QueryParameters {
        @Nullable
        public String[] expand;
        @Nullable
        public String[] select;

        @Nonnull
        public Map<String, Object> toQueryParameters() {
            HashMap<String, Object> allQueryParams = new HashMap<String, Object>();
            allQueryParams.put("%24expand", this.expand);
            allQueryParams.put("%24select", this.select);
            return allQueryParams;
        }
    }
}

