/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.security.attacksimulation;

import com.microsoft.graph.models.AttackSimulationRoot;
import com.microsoft.graph.models.odataerrors.ODataError;
import com.microsoft.graph.security.attacksimulation.endusernotifications.EndUserNotificationsRequestBuilder;
import com.microsoft.graph.security.attacksimulation.landingpages.LandingPagesRequestBuilder;
import com.microsoft.graph.security.attacksimulation.loginpages.LoginPagesRequestBuilder;
import com.microsoft.graph.security.attacksimulation.operations.OperationsRequestBuilder;
import com.microsoft.graph.security.attacksimulation.payloads.PayloadsRequestBuilder;
import com.microsoft.graph.security.attacksimulation.simulationautomations.SimulationAutomationsRequestBuilder;
import com.microsoft.graph.security.attacksimulation.simulations.SimulationsRequestBuilder;
import com.microsoft.graph.security.attacksimulation.trainings.TrainingsRequestBuilder;
import com.microsoft.kiota.BaseRequestBuilder;
import com.microsoft.kiota.BaseRequestConfiguration;
import com.microsoft.kiota.HttpMethod;
import com.microsoft.kiota.QueryParameters;
import com.microsoft.kiota.RequestAdapter;
import com.microsoft.kiota.RequestInformation;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParsableFactory;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class AttackSimulationRequestBuilder
extends BaseRequestBuilder {
    @Nonnull
    public EndUserNotificationsRequestBuilder endUserNotifications() {
        return new EndUserNotificationsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public LandingPagesRequestBuilder landingPages() {
        return new LandingPagesRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public LoginPagesRequestBuilder loginPages() {
        return new LoginPagesRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public OperationsRequestBuilder operations() {
        return new OperationsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public PayloadsRequestBuilder payloads() {
        return new PayloadsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public SimulationAutomationsRequestBuilder simulationAutomations() {
        return new SimulationAutomationsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public SimulationsRequestBuilder simulations() {
        return new SimulationsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public TrainingsRequestBuilder trainings() {
        return new TrainingsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    public AttackSimulationRequestBuilder(@Nonnull HashMap<String, Object> pathParameters, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/security/attackSimulation{?%24expand,%24select}", pathParameters);
    }

    public AttackSimulationRequestBuilder(@Nonnull String rawUrl, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/security/attackSimulation{?%24expand,%24select}", rawUrl);
    }

    public void delete() {
        this.delete(null);
    }

    public void delete(@Nullable Consumer<DeleteRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = this.toDeleteRequestInformation(requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("4XX", ODataError::createFromDiscriminatorValue);
        errorMapping.put("5XX", ODataError::createFromDiscriminatorValue);
        this.requestAdapter.sendPrimitive(requestInfo, errorMapping, Void.class);
    }

    @Nullable
    public AttackSimulationRoot get() {
        return this.get(null);
    }

    @Nullable
    public AttackSimulationRoot get(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = this.toGetRequestInformation(requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("4XX", ODataError::createFromDiscriminatorValue);
        errorMapping.put("5XX", ODataError::createFromDiscriminatorValue);
        return (AttackSimulationRoot)this.requestAdapter.send(requestInfo, errorMapping, AttackSimulationRoot::createFromDiscriminatorValue);
    }

    @Nullable
    public AttackSimulationRoot patch(@Nonnull AttackSimulationRoot body) {
        return this.patch(body, null);
    }

    @Nullable
    public AttackSimulationRoot patch(@Nonnull AttackSimulationRoot body, @Nullable Consumer<PatchRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = this.toPatchRequestInformation(body, requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("4XX", ODataError::createFromDiscriminatorValue);
        errorMapping.put("5XX", ODataError::createFromDiscriminatorValue);
        return (AttackSimulationRoot)this.requestAdapter.send(requestInfo, errorMapping, AttackSimulationRoot::createFromDiscriminatorValue);
    }

    @Nonnull
    public RequestInformation toDeleteRequestInformation() {
        return this.toDeleteRequestInformation(null);
    }

    @Nonnull
    public RequestInformation toDeleteRequestInformation(@Nullable Consumer<DeleteRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = new RequestInformation(HttpMethod.DELETE, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new DeleteRequestConfiguration());
        requestInfo.headers.tryAdd("Accept", "application/json");
        return requestInfo;
    }

    @Nonnull
    public RequestInformation toGetRequestInformation() {
        return this.toGetRequestInformation(null);
    }

    @Nonnull
    public RequestInformation toGetRequestInformation(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = new RequestInformation(HttpMethod.GET, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new GetRequestConfiguration(), x -> x.queryParameters);
        requestInfo.headers.tryAdd("Accept", "application/json");
        return requestInfo;
    }

    @Nonnull
    public RequestInformation toPatchRequestInformation(@Nonnull AttackSimulationRoot body) {
        return this.toPatchRequestInformation(body, null);
    }

    @Nonnull
    public RequestInformation toPatchRequestInformation(@Nonnull AttackSimulationRoot body, @Nullable Consumer<PatchRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = new RequestInformation(HttpMethod.PATCH, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new PatchRequestConfiguration());
        requestInfo.headers.tryAdd("Accept", "application/json");
        requestInfo.setContentFromParsable(this.requestAdapter, "application/json", (Parsable)body);
        return requestInfo;
    }

    @Nonnull
    public AttackSimulationRequestBuilder withUrl(@Nonnull String rawUrl) {
        Objects.requireNonNull(rawUrl);
        return new AttackSimulationRequestBuilder(rawUrl, this.requestAdapter);
    }

    public class PatchRequestConfiguration
    extends BaseRequestConfiguration {
    }

    public class GetRequestConfiguration
    extends BaseRequestConfiguration {
        @Nullable
        public GetQueryParameters queryParameters;

        public GetRequestConfiguration() {
            this.queryParameters = new GetQueryParameters();
        }
    }

    public class GetQueryParameters
    implements QueryParameters {
        @Nullable
        public String[] expand;
        @Nullable
        public String[] select;

        @Nonnull
        public Map<String, Object> toQueryParameters() {
            HashMap<String, Object> allQueryParams = new HashMap<String, Object>();
            allQueryParams.put("%24expand", this.expand);
            allQueryParams.put("%24select", this.select);
            return allQueryParams;
        }
    }

    public class DeleteRequestConfiguration
    extends BaseRequestConfiguration {
    }
}

