/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.termstore;

import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.KeyValue;
import com.microsoft.graph.models.termstore.LocalizedDescription;
import com.microsoft.graph.models.termstore.LocalizedLabel;
import com.microsoft.graph.models.termstore.Relation;
import com.microsoft.graph.models.termstore.Set;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class Term
extends Entity
implements Parsable {
    @Nonnull
    public static Term createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new Term();
    }

    @Nullable
    public List<Term> getChildren() {
        return (List)this.backingStore.get("children");
    }

    @Nullable
    public OffsetDateTime getCreatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("createdDateTime");
    }

    @Nullable
    public List<LocalizedDescription> getDescriptions() {
        return (List)this.backingStore.get("descriptions");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("children", n -> this.setChildren(n.getCollectionOfObjectValues(Term::createFromDiscriminatorValue)));
        deserializerMap.put("createdDateTime", n -> this.setCreatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("descriptions", n -> this.setDescriptions(n.getCollectionOfObjectValues(LocalizedDescription::createFromDiscriminatorValue)));
        deserializerMap.put("labels", n -> this.setLabels(n.getCollectionOfObjectValues(LocalizedLabel::createFromDiscriminatorValue)));
        deserializerMap.put("lastModifiedDateTime", n -> this.setLastModifiedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("properties", n -> this.setProperties(n.getCollectionOfObjectValues(KeyValue::createFromDiscriminatorValue)));
        deserializerMap.put("relations", n -> this.setRelations(n.getCollectionOfObjectValues(Relation::createFromDiscriminatorValue)));
        deserializerMap.put("set", n -> this.setSet((Set)n.getObjectValue(Set::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public List<LocalizedLabel> getLabels() {
        return (List)this.backingStore.get("labels");
    }

    @Nullable
    public OffsetDateTime getLastModifiedDateTime() {
        return (OffsetDateTime)this.backingStore.get("lastModifiedDateTime");
    }

    @Nullable
    public List<KeyValue> getProperties() {
        return (List)this.backingStore.get("properties");
    }

    @Nullable
    public List<Relation> getRelations() {
        return (List)this.backingStore.get("relations");
    }

    @Nullable
    public Set getSet() {
        return (Set)this.backingStore.get("set");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeCollectionOfObjectValues("children", this.getChildren());
        writer.writeOffsetDateTimeValue("createdDateTime", this.getCreatedDateTime());
        writer.writeCollectionOfObjectValues("descriptions", this.getDescriptions());
        writer.writeCollectionOfObjectValues("labels", this.getLabels());
        writer.writeOffsetDateTimeValue("lastModifiedDateTime", this.getLastModifiedDateTime());
        writer.writeCollectionOfObjectValues("properties", this.getProperties());
        writer.writeCollectionOfObjectValues("relations", this.getRelations());
        writer.writeObjectValue("set", (Parsable)this.getSet(), new Parsable[0]);
    }

    public void setChildren(@Nullable List<Term> value) {
        this.backingStore.set("children", value);
    }

    public void setCreatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("createdDateTime", (Object)value);
    }

    public void setDescriptions(@Nullable List<LocalizedDescription> value) {
        this.backingStore.set("descriptions", value);
    }

    public void setLabels(@Nullable List<LocalizedLabel> value) {
        this.backingStore.set("labels", value);
    }

    public void setLastModifiedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("lastModifiedDateTime", (Object)value);
    }

    public void setProperties(@Nullable List<KeyValue> value) {
        this.backingStore.set("properties", value);
    }

    public void setRelations(@Nullable List<Relation> value) {
        this.backingStore.set("relations", value);
    }

    public void setSet(@Nullable Set value) {
        this.backingStore.set("set", (Object)value);
    }
}

