/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.RiskDetail;
import com.microsoft.graph.models.RiskLevel;
import com.microsoft.graph.models.RiskState;
import com.microsoft.graph.models.RiskyServicePrincipalHistoryItem;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class RiskyServicePrincipal
extends Entity
implements Parsable {
    @Nonnull
    public static RiskyServicePrincipal createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.riskyServicePrincipalHistoryItem": {
                    return new RiskyServicePrincipalHistoryItem();
                }
            }
        }
        return new RiskyServicePrincipal();
    }

    @Nullable
    public String getAppId() {
        return (String)this.backingStore.get("appId");
    }

    @Nullable
    public String getDisplayName() {
        return (String)this.backingStore.get("displayName");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("appId", n -> this.setAppId(n.getStringValue()));
        deserializerMap.put("displayName", n -> this.setDisplayName(n.getStringValue()));
        deserializerMap.put("history", n -> this.setHistory(n.getCollectionOfObjectValues(RiskyServicePrincipalHistoryItem::createFromDiscriminatorValue)));
        deserializerMap.put("isEnabled", n -> this.setIsEnabled(n.getBooleanValue()));
        deserializerMap.put("isProcessing", n -> this.setIsProcessing(n.getBooleanValue()));
        deserializerMap.put("riskDetail", n -> this.setRiskDetail((RiskDetail)n.getEnumValue(RiskDetail::forValue)));
        deserializerMap.put("riskLastUpdatedDateTime", n -> this.setRiskLastUpdatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("riskLevel", n -> this.setRiskLevel((RiskLevel)n.getEnumValue(RiskLevel::forValue)));
        deserializerMap.put("riskState", n -> this.setRiskState((RiskState)n.getEnumValue(RiskState::forValue)));
        deserializerMap.put("servicePrincipalType", n -> this.setServicePrincipalType(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public List<RiskyServicePrincipalHistoryItem> getHistory() {
        return (List)this.backingStore.get("history");
    }

    @Nullable
    public Boolean getIsEnabled() {
        return (Boolean)this.backingStore.get("isEnabled");
    }

    @Nullable
    public Boolean getIsProcessing() {
        return (Boolean)this.backingStore.get("isProcessing");
    }

    @Nullable
    public RiskDetail getRiskDetail() {
        return (RiskDetail)((Object)this.backingStore.get("riskDetail"));
    }

    @Nullable
    public OffsetDateTime getRiskLastUpdatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("riskLastUpdatedDateTime");
    }

    @Nullable
    public RiskLevel getRiskLevel() {
        return (RiskLevel)((Object)this.backingStore.get("riskLevel"));
    }

    @Nullable
    public RiskState getRiskState() {
        return (RiskState)((Object)this.backingStore.get("riskState"));
    }

    @Nullable
    public String getServicePrincipalType() {
        return (String)this.backingStore.get("servicePrincipalType");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeStringValue("appId", this.getAppId());
        writer.writeStringValue("displayName", this.getDisplayName());
        writer.writeCollectionOfObjectValues("history", this.getHistory());
        writer.writeBooleanValue("isEnabled", this.getIsEnabled());
        writer.writeBooleanValue("isProcessing", this.getIsProcessing());
        writer.writeEnumValue("riskDetail", (Enum)this.getRiskDetail());
        writer.writeOffsetDateTimeValue("riskLastUpdatedDateTime", this.getRiskLastUpdatedDateTime());
        writer.writeEnumValue("riskLevel", (Enum)this.getRiskLevel());
        writer.writeEnumValue("riskState", (Enum)this.getRiskState());
        writer.writeStringValue("servicePrincipalType", this.getServicePrincipalType());
    }

    public void setAppId(@Nullable String value) {
        this.backingStore.set("appId", (Object)value);
    }

    public void setDisplayName(@Nullable String value) {
        this.backingStore.set("displayName", (Object)value);
    }

    public void setHistory(@Nullable List<RiskyServicePrincipalHistoryItem> value) {
        this.backingStore.set("history", value);
    }

    public void setIsEnabled(@Nullable Boolean value) {
        this.backingStore.set("isEnabled", (Object)value);
    }

    public void setIsProcessing(@Nullable Boolean value) {
        this.backingStore.set("isProcessing", (Object)value);
    }

    public void setRiskDetail(@Nullable RiskDetail value) {
        this.backingStore.set("riskDetail", (Object)value);
    }

    public void setRiskLastUpdatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("riskLastUpdatedDateTime", (Object)value);
    }

    public void setRiskLevel(@Nullable RiskLevel value) {
        this.backingStore.set("riskLevel", (Object)value);
    }

    public void setRiskState(@Nullable RiskState value) {
        this.backingStore.set("riskState", (Object)value);
    }

    public void setServicePrincipalType(@Nullable String value) {
        this.backingStore.set("servicePrincipalType", (Object)value);
    }
}

