/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.FileHash;
import com.microsoft.graph.models.ProcessIntegrityLevel;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class Process
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public Process() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static Process createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new Process();
    }

    @Nullable
    public String getAccountName() {
        return (String)this.backingStore.get("accountName");
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public String getCommandLine() {
        return (String)this.backingStore.get("commandLine");
    }

    @Nullable
    public OffsetDateTime getCreatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("createdDateTime");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(13);
        deserializerMap.put("accountName", n -> this.setAccountName(n.getStringValue()));
        deserializerMap.put("commandLine", n -> this.setCommandLine(n.getStringValue()));
        deserializerMap.put("createdDateTime", n -> this.setCreatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("fileHash", n -> this.setFileHash((FileHash)n.getObjectValue(FileHash::createFromDiscriminatorValue)));
        deserializerMap.put("integrityLevel", n -> this.setIntegrityLevel((ProcessIntegrityLevel)n.getEnumValue(ProcessIntegrityLevel::forValue)));
        deserializerMap.put("isElevated", n -> this.setIsElevated(n.getBooleanValue()));
        deserializerMap.put("name", n -> this.setName(n.getStringValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("parentProcessCreatedDateTime", n -> this.setParentProcessCreatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("parentProcessId", n -> this.setParentProcessId(n.getIntegerValue()));
        deserializerMap.put("parentProcessName", n -> this.setParentProcessName(n.getStringValue()));
        deserializerMap.put("path", n -> this.setPath(n.getStringValue()));
        deserializerMap.put("processId", n -> this.setProcessId(n.getIntegerValue()));
        return deserializerMap;
    }

    @Nullable
    public FileHash getFileHash() {
        return (FileHash)this.backingStore.get("fileHash");
    }

    @Nullable
    public ProcessIntegrityLevel getIntegrityLevel() {
        return (ProcessIntegrityLevel)((Object)this.backingStore.get("integrityLevel"));
    }

    @Nullable
    public Boolean getIsElevated() {
        return (Boolean)this.backingStore.get("isElevated");
    }

    @Nullable
    public String getName() {
        return (String)this.backingStore.get("name");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public OffsetDateTime getParentProcessCreatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("parentProcessCreatedDateTime");
    }

    @Nullable
    public Integer getParentProcessId() {
        return (Integer)this.backingStore.get("parentProcessId");
    }

    @Nullable
    public String getParentProcessName() {
        return (String)this.backingStore.get("parentProcessName");
    }

    @Nullable
    public String getPath() {
        return (String)this.backingStore.get("path");
    }

    @Nullable
    public Integer getProcessId() {
        return (Integer)this.backingStore.get("processId");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeStringValue("accountName", this.getAccountName());
        writer.writeStringValue("commandLine", this.getCommandLine());
        writer.writeOffsetDateTimeValue("createdDateTime", this.getCreatedDateTime());
        writer.writeObjectValue("fileHash", (Parsable)this.getFileHash(), new Parsable[0]);
        writer.writeEnumValue("integrityLevel", (Enum)this.getIntegrityLevel());
        writer.writeBooleanValue("isElevated", this.getIsElevated());
        writer.writeStringValue("name", this.getName());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeOffsetDateTimeValue("parentProcessCreatedDateTime", this.getParentProcessCreatedDateTime());
        writer.writeIntegerValue("parentProcessId", this.getParentProcessId());
        writer.writeStringValue("parentProcessName", this.getParentProcessName());
        writer.writeStringValue("path", this.getPath());
        writer.writeIntegerValue("processId", this.getProcessId());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAccountName(@Nullable String value) {
        this.backingStore.set("accountName", (Object)value);
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setCommandLine(@Nullable String value) {
        this.backingStore.set("commandLine", (Object)value);
    }

    public void setCreatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("createdDateTime", (Object)value);
    }

    public void setFileHash(@Nullable FileHash value) {
        this.backingStore.set("fileHash", (Object)value);
    }

    public void setIntegrityLevel(@Nullable ProcessIntegrityLevel value) {
        this.backingStore.set("integrityLevel", (Object)value);
    }

    public void setIsElevated(@Nullable Boolean value) {
        this.backingStore.set("isElevated", (Object)value);
    }

    public void setName(@Nullable String value) {
        this.backingStore.set("name", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setParentProcessCreatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("parentProcessCreatedDateTime", (Object)value);
    }

    public void setParentProcessId(@Nullable Integer value) {
        this.backingStore.set("parentProcessId", (Object)value);
    }

    public void setParentProcessName(@Nullable String value) {
        this.backingStore.set("parentProcessName", (Object)value);
    }

    public void setPath(@Nullable String value) {
        this.backingStore.set("path", (Object)value);
    }

    public void setProcessId(@Nullable Integer value) {
        this.backingStore.set("processId", (Object)value);
    }
}

