// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.ParticipantLeftNotification;
import com.microsoft.graph.requests.CallRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Participant Left Notification Request.
 */
public class ParticipantLeftNotificationRequest extends BaseRequest<ParticipantLeftNotification> {
	
    /**
     * The request for the ParticipantLeftNotification
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ParticipantLeftNotificationRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, ParticipantLeftNotification.class);
    }

    /**
     * Gets the ParticipantLeftNotification from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ParticipantLeftNotification> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the ParticipantLeftNotification from the service
     *
     * @return the ParticipantLeftNotification from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ParticipantLeftNotification get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ParticipantLeftNotification> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public ParticipantLeftNotification delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this ParticipantLeftNotification with a source
     *
     * @param sourceParticipantLeftNotification the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ParticipantLeftNotification> patchAsync(@Nonnull final ParticipantLeftNotification sourceParticipantLeftNotification) {
        return sendAsync(HttpMethod.PATCH, sourceParticipantLeftNotification);
    }

    /**
     * Patches this ParticipantLeftNotification with a source
     *
     * @param sourceParticipantLeftNotification the source object with updates
     * @return the updated ParticipantLeftNotification
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ParticipantLeftNotification patch(@Nonnull final ParticipantLeftNotification sourceParticipantLeftNotification) throws ClientException {
        return send(HttpMethod.PATCH, sourceParticipantLeftNotification);
    }

    /**
     * Creates a ParticipantLeftNotification with a new object
     *
     * @param newParticipantLeftNotification the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ParticipantLeftNotification> postAsync(@Nonnull final ParticipantLeftNotification newParticipantLeftNotification) {
        return sendAsync(HttpMethod.POST, newParticipantLeftNotification);
    }

    /**
     * Creates a ParticipantLeftNotification with a new object
     *
     * @param newParticipantLeftNotification the new object to create
     * @return the created ParticipantLeftNotification
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ParticipantLeftNotification post(@Nonnull final ParticipantLeftNotification newParticipantLeftNotification) throws ClientException {
        return send(HttpMethod.POST, newParticipantLeftNotification);
    }

    /**
     * Creates a ParticipantLeftNotification with a new object
     *
     * @param newParticipantLeftNotification the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ParticipantLeftNotification> putAsync(@Nonnull final ParticipantLeftNotification newParticipantLeftNotification) {
        return sendAsync(HttpMethod.PUT, newParticipantLeftNotification);
    }

    /**
     * Creates a ParticipantLeftNotification with a new object
     *
     * @param newParticipantLeftNotification the object to create/update
     * @return the created ParticipantLeftNotification
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ParticipantLeftNotification put(@Nonnull final ParticipantLeftNotification newParticipantLeftNotification) throws ClientException {
        return send(HttpMethod.PUT, newParticipantLeftNotification);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public ParticipantLeftNotificationRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public ParticipantLeftNotificationRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

