// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.security.models.TriggersRoot;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Triggers Root Request.
 */
public class TriggersRootRequest extends BaseRequest<TriggersRoot> {
	
    /**
     * The request for the TriggersRoot
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public TriggersRootRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, TriggersRoot.class);
    }

    /**
     * Gets the TriggersRoot from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TriggersRoot> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the TriggersRoot from the service
     *
     * @return the TriggersRoot from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TriggersRoot get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TriggersRoot> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public TriggersRoot delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this TriggersRoot with a source
     *
     * @param sourceTriggersRoot the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TriggersRoot> patchAsync(@Nonnull final TriggersRoot sourceTriggersRoot) {
        return sendAsync(HttpMethod.PATCH, sourceTriggersRoot);
    }

    /**
     * Patches this TriggersRoot with a source
     *
     * @param sourceTriggersRoot the source object with updates
     * @return the updated TriggersRoot
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TriggersRoot patch(@Nonnull final TriggersRoot sourceTriggersRoot) throws ClientException {
        return send(HttpMethod.PATCH, sourceTriggersRoot);
    }

    /**
     * Creates a TriggersRoot with a new object
     *
     * @param newTriggersRoot the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TriggersRoot> postAsync(@Nonnull final TriggersRoot newTriggersRoot) {
        return sendAsync(HttpMethod.POST, newTriggersRoot);
    }

    /**
     * Creates a TriggersRoot with a new object
     *
     * @param newTriggersRoot the new object to create
     * @return the created TriggersRoot
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TriggersRoot post(@Nonnull final TriggersRoot newTriggersRoot) throws ClientException {
        return send(HttpMethod.POST, newTriggersRoot);
    }

    /**
     * Creates a TriggersRoot with a new object
     *
     * @param newTriggersRoot the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TriggersRoot> putAsync(@Nonnull final TriggersRoot newTriggersRoot) {
        return sendAsync(HttpMethod.PUT, newTriggersRoot);
    }

    /**
     * Creates a TriggersRoot with a new object
     *
     * @param newTriggersRoot the object to create/update
     * @return the created TriggersRoot
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TriggersRoot put(@Nonnull final TriggersRoot newTriggersRoot) throws ClientException {
        return send(HttpMethod.PUT, newTriggersRoot);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public TriggersRootRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public TriggersRootRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

