// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.security.models.IntelligenceProfile;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Intelligence Profile Request.
 */
public class IntelligenceProfileRequest extends BaseRequest<IntelligenceProfile> {
	
    /**
     * The request for the IntelligenceProfile
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public IntelligenceProfileRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, IntelligenceProfile.class);
    }

    /**
     * Gets the IntelligenceProfile from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<IntelligenceProfile> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the IntelligenceProfile from the service
     *
     * @return the IntelligenceProfile from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public IntelligenceProfile get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<IntelligenceProfile> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public IntelligenceProfile delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this IntelligenceProfile with a source
     *
     * @param sourceIntelligenceProfile the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<IntelligenceProfile> patchAsync(@Nonnull final IntelligenceProfile sourceIntelligenceProfile) {
        return sendAsync(HttpMethod.PATCH, sourceIntelligenceProfile);
    }

    /**
     * Patches this IntelligenceProfile with a source
     *
     * @param sourceIntelligenceProfile the source object with updates
     * @return the updated IntelligenceProfile
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public IntelligenceProfile patch(@Nonnull final IntelligenceProfile sourceIntelligenceProfile) throws ClientException {
        return send(HttpMethod.PATCH, sourceIntelligenceProfile);
    }

    /**
     * Creates a IntelligenceProfile with a new object
     *
     * @param newIntelligenceProfile the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<IntelligenceProfile> postAsync(@Nonnull final IntelligenceProfile newIntelligenceProfile) {
        return sendAsync(HttpMethod.POST, newIntelligenceProfile);
    }

    /**
     * Creates a IntelligenceProfile with a new object
     *
     * @param newIntelligenceProfile the new object to create
     * @return the created IntelligenceProfile
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public IntelligenceProfile post(@Nonnull final IntelligenceProfile newIntelligenceProfile) throws ClientException {
        return send(HttpMethod.POST, newIntelligenceProfile);
    }

    /**
     * Creates a IntelligenceProfile with a new object
     *
     * @param newIntelligenceProfile the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<IntelligenceProfile> putAsync(@Nonnull final IntelligenceProfile newIntelligenceProfile) {
        return sendAsync(HttpMethod.PUT, newIntelligenceProfile);
    }

    /**
     * Creates a IntelligenceProfile with a new object
     *
     * @param newIntelligenceProfile the object to create/update
     * @return the created IntelligenceProfile
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public IntelligenceProfile put(@Nonnull final IntelligenceProfile newIntelligenceProfile) throws ClientException {
        return send(HttpMethod.PUT, newIntelligenceProfile);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public IntelligenceProfileRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public IntelligenceProfileRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

