// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.security.models.HostPair;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Host Pair Request.
 */
public class HostPairRequest extends BaseRequest<HostPair> {
	
    /**
     * The request for the HostPair
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public HostPairRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, HostPair.class);
    }

    /**
     * Gets the HostPair from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<HostPair> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the HostPair from the service
     *
     * @return the HostPair from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public HostPair get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<HostPair> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public HostPair delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this HostPair with a source
     *
     * @param sourceHostPair the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<HostPair> patchAsync(@Nonnull final HostPair sourceHostPair) {
        return sendAsync(HttpMethod.PATCH, sourceHostPair);
    }

    /**
     * Patches this HostPair with a source
     *
     * @param sourceHostPair the source object with updates
     * @return the updated HostPair
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public HostPair patch(@Nonnull final HostPair sourceHostPair) throws ClientException {
        return send(HttpMethod.PATCH, sourceHostPair);
    }

    /**
     * Creates a HostPair with a new object
     *
     * @param newHostPair the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<HostPair> postAsync(@Nonnull final HostPair newHostPair) {
        return sendAsync(HttpMethod.POST, newHostPair);
    }

    /**
     * Creates a HostPair with a new object
     *
     * @param newHostPair the new object to create
     * @return the created HostPair
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public HostPair post(@Nonnull final HostPair newHostPair) throws ClientException {
        return send(HttpMethod.POST, newHostPair);
    }

    /**
     * Creates a HostPair with a new object
     *
     * @param newHostPair the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<HostPair> putAsync(@Nonnull final HostPair newHostPair) {
        return sendAsync(HttpMethod.PUT, newHostPair);
    }

    /**
     * Creates a HostPair with a new object
     *
     * @param newHostPair the object to create/update
     * @return the created HostPair
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public HostPair put(@Nonnull final HostPair newHostPair) throws ClientException {
        return send(HttpMethod.PUT, newHostPair);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public HostPairRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public HostPairRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

