// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.security.models.WhoisContact;
import com.microsoft.graph.security.models.WhoisNameserver;
import com.microsoft.graph.security.models.Host;
import com.microsoft.graph.models.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Whois Base Record.
 */
public class WhoisBaseRecord extends Entity implements IJsonBackedObject {


    /**
     * The Abuse.
     * The contact information for the abuse contact.
     */
    @SerializedName(value = "abuse", alternate = {"Abuse"})
    @Expose
	@Nullable
    public WhoisContact abuse;

    /**
     * The Admin.
     * The contact information for the admin contact.
     */
    @SerializedName(value = "admin", alternate = {"Admin"})
    @Expose
	@Nullable
    public WhoisContact admin;

    /**
     * The Billing.
     * The contact information for the billing contact.
     */
    @SerializedName(value = "billing", alternate = {"Billing"})
    @Expose
	@Nullable
    public WhoisContact billing;

    /**
     * The Domain Status.
     * The domain status for this WHOIS object.
     */
    @SerializedName(value = "domainStatus", alternate = {"DomainStatus"})
    @Expose
	@Nullable
    public String domainStatus;

    /**
     * The Expiration Date Time.
     * The date and time when this WHOIS record expires with the registrar. The timestamp type represents date and time information using ISO 8601 format and is always in UTC. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z.
     */
    @SerializedName(value = "expirationDateTime", alternate = {"ExpirationDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime expirationDateTime;

    /**
     * The First Seen Date Time.
     * The first seen date and time of this WHOIS record. The timestamp type represents date and time information using ISO 8601 format and is always in UTC. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z.
     */
    @SerializedName(value = "firstSeenDateTime", alternate = {"FirstSeenDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime firstSeenDateTime;

    /**
     * The Last Seen Date Time.
     * The last seen date and time of this WHOIS record. The timestamp type represents date and time information using ISO 8601 format and is always in UTC. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z.
     */
    @SerializedName(value = "lastSeenDateTime", alternate = {"LastSeenDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime lastSeenDateTime;

    /**
     * The Last Update Date Time.
     * The date and time when this WHOIS record was last modified. The timestamp type represents date and time information using ISO 8601 format and is always in UTC. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z.
     */
    @SerializedName(value = "lastUpdateDateTime", alternate = {"LastUpdateDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime lastUpdateDateTime;

    /**
     * The Nameservers.
     * The nameservers for this WHOIS object.
     */
    @SerializedName(value = "nameservers", alternate = {"Nameservers"})
    @Expose
	@Nullable
    public java.util.List<WhoisNameserver> nameservers;

    /**
     * The Noc.
     * The contact information for the noc contact.
     */
    @SerializedName(value = "noc", alternate = {"Noc"})
    @Expose
	@Nullable
    public WhoisContact noc;

    /**
     * The Raw Whois Text.
     * The raw WHOIS details for this WHOIS object.
     */
    @SerializedName(value = "rawWhoisText", alternate = {"RawWhoisText"})
    @Expose
	@Nullable
    public String rawWhoisText;

    /**
     * The Registrant.
     * The contact information for the registrant contact.
     */
    @SerializedName(value = "registrant", alternate = {"Registrant"})
    @Expose
	@Nullable
    public WhoisContact registrant;

    /**
     * The Registrar.
     * The contact information for the registrar contact.
     */
    @SerializedName(value = "registrar", alternate = {"Registrar"})
    @Expose
	@Nullable
    public WhoisContact registrar;

    /**
     * The Registration Date Time.
     * The date and time when this WHOIS record was registered with a registrar. The timestamp type represents date and time information using ISO 8601 format and is always in UTC. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z.
     */
    @SerializedName(value = "registrationDateTime", alternate = {"RegistrationDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime registrationDateTime;

    /**
     * The Technical.
     * The contact information for the technical contact.
     */
    @SerializedName(value = "technical", alternate = {"Technical"})
    @Expose
	@Nullable
    public WhoisContact technical;

    /**
     * The Whois Server.
     * The WHOIS server that provides the details.
     */
    @SerializedName(value = "whoisServer", alternate = {"WhoisServer"})
    @Expose
	@Nullable
    public String whoisServer;

    /**
     * The Zone.
     * The contact information for the zone contact.
     */
    @SerializedName(value = "zone", alternate = {"Zone"})
    @Expose
	@Nullable
    public WhoisContact zone;

    /**
     * The Host.
     * The host associated to this WHOIS object.
     */
    @SerializedName(value = "host", alternate = {"Host"})
    @Expose
	@Nullable
    public Host host;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
