// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.security.models.ServicePrincipalType;
import com.microsoft.graph.security.models.AlertEvidence;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Service Principal Evidence.
 */
public class ServicePrincipalEvidence extends AlertEvidence implements IJsonBackedObject {


    /**
     * The App Id.
     * 
     */
    @SerializedName(value = "appId", alternate = {"AppId"})
    @Expose
	@Nullable
    public String appId;

    /**
     * The App Owner Tenant Id.
     * 
     */
    @SerializedName(value = "appOwnerTenantId", alternate = {"AppOwnerTenantId"})
    @Expose
	@Nullable
    public String appOwnerTenantId;

    /**
     * The Service Principal Name.
     * 
     */
    @SerializedName(value = "servicePrincipalName", alternate = {"ServicePrincipalName"})
    @Expose
	@Nullable
    public String servicePrincipalName;

    /**
     * The Service Principal Object Id.
     * 
     */
    @SerializedName(value = "servicePrincipalObjectId", alternate = {"ServicePrincipalObjectId"})
    @Expose
	@Nullable
    public String servicePrincipalObjectId;

    /**
     * The Service Principal Type.
     * 
     */
    @SerializedName(value = "servicePrincipalType", alternate = {"ServicePrincipalType"})
    @Expose
	@Nullable
    public ServicePrincipalType servicePrincipalType;

    /**
     * The Tenant Id.
     * 
     */
    @SerializedName(value = "tenantId", alternate = {"TenantId"})
    @Expose
	@Nullable
    public String tenantId;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
