// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.security.models.AlertEvidence;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Git Hub Repo Evidence.
 */
public class GitHubRepoEvidence extends AlertEvidence implements IJsonBackedObject {


    /**
     * The Base Url.
     * 
     */
    @SerializedName(value = "baseUrl", alternate = {"BaseUrl"})
    @Expose
	@Nullable
    public String baseUrl;

    /**
     * The Login.
     * 
     */
    @SerializedName(value = "login", alternate = {"Login"})
    @Expose
	@Nullable
    public String login;

    /**
     * The Owner.
     * 
     */
    @SerializedName(value = "owner", alternate = {"Owner"})
    @Expose
	@Nullable
    public String owner;

    /**
     * The Owner Type.
     * 
     */
    @SerializedName(value = "ownerType", alternate = {"OwnerType"})
    @Expose
	@Nullable
    public String ownerType;

    /**
     * The Repo Id.
     * 
     */
    @SerializedName(value = "repoId", alternate = {"RepoId"})
    @Expose
	@Nullable
    public String repoId;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
