// Template Source: BaseEntityCollectionWithReferencesPage.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.security.models.Host;
import com.microsoft.graph.security.models.PassiveDnsRecord;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.security.requests.PassiveDnsRecordCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.security.requests.PassiveDnsRecordCollectionWithReferencesPage;
import com.microsoft.graph.security.requests.PassiveDnsRecordCollectionResponse;
import com.microsoft.graph.security.models.PassiveDnsRecord;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import com.microsoft.graph.http.BaseCollectionPage;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Passive Dns Record Collection With References Page.
 */
public class PassiveDnsRecordCollectionWithReferencesPage extends BaseCollectionPage<PassiveDnsRecord, PassiveDnsRecordCollectionWithReferencesRequestBuilder> {

    /**
     * A collection page for PassiveDnsRecord
     *
     * @param response the serialized PassiveDnsRecordCollectionResponse from the service
     * @param builder  the request builder for the next collection page
     */
    public PassiveDnsRecordCollectionWithReferencesPage(@Nonnull final PassiveDnsRecordCollectionResponse response, @Nullable final PassiveDnsRecordCollectionWithReferencesRequestBuilder builder) {
        super(response.value, builder, response.additionalDataManager());
    }

    /**
     * Creates the collection page for PassiveDnsRecord
     *
     * @param pageContents       the contents of this page
     * @param nextRequestBuilder the request builder for the next page
     */
    public PassiveDnsRecordCollectionWithReferencesPage(@Nonnull final java.util.List<PassiveDnsRecord> pageContents, @Nullable final PassiveDnsRecordCollectionWithReferencesRequestBuilder nextRequestBuilder) {
        super(pageContents, nextRequestBuilder);
    }
}
