// Template Source: BaseEntityCollectionWithReferencesPage.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.security.models.Host;
import com.microsoft.graph.security.models.HostPort;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.security.requests.HostPortCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.security.requests.HostPortCollectionWithReferencesPage;
import com.microsoft.graph.security.requests.HostPortCollectionResponse;
import com.microsoft.graph.security.models.HostPort;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import com.microsoft.graph.http.BaseCollectionPage;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Host Port Collection With References Page.
 */
public class HostPortCollectionWithReferencesPage extends BaseCollectionPage<HostPort, HostPortCollectionWithReferencesRequestBuilder> {

    /**
     * A collection page for HostPort
     *
     * @param response the serialized HostPortCollectionResponse from the service
     * @param builder  the request builder for the next collection page
     */
    public HostPortCollectionWithReferencesPage(@Nonnull final HostPortCollectionResponse response, @Nullable final HostPortCollectionWithReferencesRequestBuilder builder) {
        super(response.value, builder, response.additionalDataManager());
    }

    /**
     * Creates the collection page for HostPort
     *
     * @param pageContents       the contents of this page
     * @param nextRequestBuilder the request builder for the next page
     */
    public HostPortCollectionWithReferencesPage(@Nonnull final java.util.List<HostPort> pageContents, @Nullable final HostPortCollectionWithReferencesRequestBuilder nextRequestBuilder) {
        super(pageContents, nextRequestBuilder);
    }
}
