// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.SynchronizationTemplate;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Synchronization Template Request.
 */
public class SynchronizationTemplateRequest extends BaseRequest<SynchronizationTemplate> {
	
    /**
     * The request for the SynchronizationTemplate
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public SynchronizationTemplateRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, SynchronizationTemplate.class);
    }

    /**
     * Gets the SynchronizationTemplate from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SynchronizationTemplate> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the SynchronizationTemplate from the service
     *
     * @return the SynchronizationTemplate from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SynchronizationTemplate get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SynchronizationTemplate> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public SynchronizationTemplate delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this SynchronizationTemplate with a source
     *
     * @param sourceSynchronizationTemplate the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SynchronizationTemplate> patchAsync(@Nonnull final SynchronizationTemplate sourceSynchronizationTemplate) {
        return sendAsync(HttpMethod.PATCH, sourceSynchronizationTemplate);
    }

    /**
     * Patches this SynchronizationTemplate with a source
     *
     * @param sourceSynchronizationTemplate the source object with updates
     * @return the updated SynchronizationTemplate
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SynchronizationTemplate patch(@Nonnull final SynchronizationTemplate sourceSynchronizationTemplate) throws ClientException {
        return send(HttpMethod.PATCH, sourceSynchronizationTemplate);
    }

    /**
     * Creates a SynchronizationTemplate with a new object
     *
     * @param newSynchronizationTemplate the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SynchronizationTemplate> postAsync(@Nonnull final SynchronizationTemplate newSynchronizationTemplate) {
        return sendAsync(HttpMethod.POST, newSynchronizationTemplate);
    }

    /**
     * Creates a SynchronizationTemplate with a new object
     *
     * @param newSynchronizationTemplate the new object to create
     * @return the created SynchronizationTemplate
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SynchronizationTemplate post(@Nonnull final SynchronizationTemplate newSynchronizationTemplate) throws ClientException {
        return send(HttpMethod.POST, newSynchronizationTemplate);
    }

    /**
     * Creates a SynchronizationTemplate with a new object
     *
     * @param newSynchronizationTemplate the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SynchronizationTemplate> putAsync(@Nonnull final SynchronizationTemplate newSynchronizationTemplate) {
        return sendAsync(HttpMethod.PUT, newSynchronizationTemplate);
    }

    /**
     * Creates a SynchronizationTemplate with a new object
     *
     * @param newSynchronizationTemplate the object to create/update
     * @return the created SynchronizationTemplate
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SynchronizationTemplate put(@Nonnull final SynchronizationTemplate newSynchronizationTemplate) throws ClientException {
        return send(HttpMethod.PUT, newSynchronizationTemplate);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public SynchronizationTemplateRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public SynchronizationTemplateRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

