// Template Source: BaseMethodCollectionPage.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.Site;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.http.DeltaCollectionPage;
import com.microsoft.graph.requests.SiteDeltaCollectionRequestBuilder;
import com.microsoft.graph.requests.SiteDeltaCollectionPage;
import com.microsoft.graph.requests.SiteDeltaCollectionResponse;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Site Delta Collection Page.
 */
public class SiteDeltaCollectionPage extends DeltaCollectionPage<Site, SiteDeltaCollectionRequestBuilder> {

    /**
     * A collection page for Site.
     *
     * @param response The serialized SiteDeltaCollectionResponse from the service
     * @param builder The request builder for the next collection page
     */
    public SiteDeltaCollectionPage(@Nonnull final SiteDeltaCollectionResponse response, @Nonnull final SiteDeltaCollectionRequestBuilder builder) {
       super(response, builder);
    }

	/**
     * Creates the collection page for SiteDelta
     *
     * @param pageContents       the contents of this page
     * @param nextRequestBuilder the request builder for the next page
     */
    public SiteDeltaCollectionPage(@Nonnull final java.util.List<Site> pageContents, @Nullable final SiteDeltaCollectionRequestBuilder nextRequestBuilder) {
        super(pageContents, nextRequestBuilder);
    }
}
