// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.ResellerDelegatedAdminRelationship;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Reseller Delegated Admin Relationship Request Builder.
 */
public class ResellerDelegatedAdminRelationshipRequestBuilder extends BaseRequestBuilder<ResellerDelegatedAdminRelationship> {

    /**
     * The request builder for the ResellerDelegatedAdminRelationship
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ResellerDelegatedAdminRelationshipRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the ResellerDelegatedAdminRelationshipRequest instance
     */
    @Nonnull
    public ResellerDelegatedAdminRelationshipRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the ResellerDelegatedAdminRelationshipRequest instance
     */
    @Nonnull
    public ResellerDelegatedAdminRelationshipRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.requests.ResellerDelegatedAdminRelationshipRequest(getRequestUrl(), getClient(), requestOptions);
    }


    /**
     *  Gets a request builder for the DelegatedAdminAccessAssignment collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.DelegatedAdminAccessAssignmentCollectionRequestBuilder accessAssignments() {
        return new com.microsoft.graph.requests.DelegatedAdminAccessAssignmentCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("accessAssignments"), getClient(), null);
    }

    /**
     * Gets a request builder for the DelegatedAdminAccessAssignment item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.DelegatedAdminAccessAssignmentRequestBuilder accessAssignments(@Nonnull final String id) {
        return new com.microsoft.graph.requests.DelegatedAdminAccessAssignmentRequestBuilder(getRequestUrlWithAdditionalSegment("accessAssignments") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the DelegatedAdminRelationshipOperation collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.DelegatedAdminRelationshipOperationCollectionRequestBuilder operations() {
        return new com.microsoft.graph.requests.DelegatedAdminRelationshipOperationCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("operations"), getClient(), null);
    }

    /**
     * Gets a request builder for the DelegatedAdminRelationshipOperation item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.DelegatedAdminRelationshipOperationRequestBuilder operations(@Nonnull final String id) {
        return new com.microsoft.graph.requests.DelegatedAdminRelationshipOperationRequestBuilder(getRequestUrlWithAdditionalSegment("operations") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the DelegatedAdminRelationshipRequest collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.DelegatedAdminRelationshipRequestCollectionRequestBuilder requests() {
        return new com.microsoft.graph.requests.DelegatedAdminRelationshipRequestCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("requests"), getClient(), null);
    }

    /**
     * Gets a request builder for the DelegatedAdminRelationshipRequest item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.DelegatedAdminRelationshipRequestRequestBuilder requests(@Nonnull final String id) {
        return new com.microsoft.graph.requests.DelegatedAdminRelationshipRequestRequestBuilder(getRequestUrlWithAdditionalSegment("requests") + "/" + id, getClient(), null);
    }
}
