// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.ResellerDelegatedAdminRelationship;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Reseller Delegated Admin Relationship Request.
 */
public class ResellerDelegatedAdminRelationshipRequest extends BaseRequest<ResellerDelegatedAdminRelationship> {
	
    /**
     * The request for the ResellerDelegatedAdminRelationship
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ResellerDelegatedAdminRelationshipRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, ResellerDelegatedAdminRelationship.class);
    }

    /**
     * Gets the ResellerDelegatedAdminRelationship from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ResellerDelegatedAdminRelationship> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the ResellerDelegatedAdminRelationship from the service
     *
     * @return the ResellerDelegatedAdminRelationship from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ResellerDelegatedAdminRelationship get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ResellerDelegatedAdminRelationship> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public ResellerDelegatedAdminRelationship delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this ResellerDelegatedAdminRelationship with a source
     *
     * @param sourceResellerDelegatedAdminRelationship the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ResellerDelegatedAdminRelationship> patchAsync(@Nonnull final ResellerDelegatedAdminRelationship sourceResellerDelegatedAdminRelationship) {
        return sendAsync(HttpMethod.PATCH, sourceResellerDelegatedAdminRelationship);
    }

    /**
     * Patches this ResellerDelegatedAdminRelationship with a source
     *
     * @param sourceResellerDelegatedAdminRelationship the source object with updates
     * @return the updated ResellerDelegatedAdminRelationship
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ResellerDelegatedAdminRelationship patch(@Nonnull final ResellerDelegatedAdminRelationship sourceResellerDelegatedAdminRelationship) throws ClientException {
        return send(HttpMethod.PATCH, sourceResellerDelegatedAdminRelationship);
    }

    /**
     * Creates a ResellerDelegatedAdminRelationship with a new object
     *
     * @param newResellerDelegatedAdminRelationship the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ResellerDelegatedAdminRelationship> postAsync(@Nonnull final ResellerDelegatedAdminRelationship newResellerDelegatedAdminRelationship) {
        return sendAsync(HttpMethod.POST, newResellerDelegatedAdminRelationship);
    }

    /**
     * Creates a ResellerDelegatedAdminRelationship with a new object
     *
     * @param newResellerDelegatedAdminRelationship the new object to create
     * @return the created ResellerDelegatedAdminRelationship
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ResellerDelegatedAdminRelationship post(@Nonnull final ResellerDelegatedAdminRelationship newResellerDelegatedAdminRelationship) throws ClientException {
        return send(HttpMethod.POST, newResellerDelegatedAdminRelationship);
    }

    /**
     * Creates a ResellerDelegatedAdminRelationship with a new object
     *
     * @param newResellerDelegatedAdminRelationship the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ResellerDelegatedAdminRelationship> putAsync(@Nonnull final ResellerDelegatedAdminRelationship newResellerDelegatedAdminRelationship) {
        return sendAsync(HttpMethod.PUT, newResellerDelegatedAdminRelationship);
    }

    /**
     * Creates a ResellerDelegatedAdminRelationship with a new object
     *
     * @param newResellerDelegatedAdminRelationship the object to create/update
     * @return the created ResellerDelegatedAdminRelationship
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ResellerDelegatedAdminRelationship put(@Nonnull final ResellerDelegatedAdminRelationship newResellerDelegatedAdminRelationship) throws ClientException {
        return send(HttpMethod.PUT, newResellerDelegatedAdminRelationship);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public ResellerDelegatedAdminRelationshipRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public ResellerDelegatedAdminRelationshipRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

