// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.PronounsSettings;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Pronouns Settings Request.
 */
public class PronounsSettingsRequest extends BaseRequest<PronounsSettings> {
	
    /**
     * The request for the PronounsSettings
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public PronounsSettingsRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, PronounsSettings.class);
    }

    /**
     * Gets the PronounsSettings from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PronounsSettings> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the PronounsSettings from the service
     *
     * @return the PronounsSettings from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PronounsSettings get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PronounsSettings> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public PronounsSettings delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this PronounsSettings with a source
     *
     * @param sourcePronounsSettings the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PronounsSettings> patchAsync(@Nonnull final PronounsSettings sourcePronounsSettings) {
        return sendAsync(HttpMethod.PATCH, sourcePronounsSettings);
    }

    /**
     * Patches this PronounsSettings with a source
     *
     * @param sourcePronounsSettings the source object with updates
     * @return the updated PronounsSettings
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PronounsSettings patch(@Nonnull final PronounsSettings sourcePronounsSettings) throws ClientException {
        return send(HttpMethod.PATCH, sourcePronounsSettings);
    }

    /**
     * Creates a PronounsSettings with a new object
     *
     * @param newPronounsSettings the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PronounsSettings> postAsync(@Nonnull final PronounsSettings newPronounsSettings) {
        return sendAsync(HttpMethod.POST, newPronounsSettings);
    }

    /**
     * Creates a PronounsSettings with a new object
     *
     * @param newPronounsSettings the new object to create
     * @return the created PronounsSettings
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PronounsSettings post(@Nonnull final PronounsSettings newPronounsSettings) throws ClientException {
        return send(HttpMethod.POST, newPronounsSettings);
    }

    /**
     * Creates a PronounsSettings with a new object
     *
     * @param newPronounsSettings the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PronounsSettings> putAsync(@Nonnull final PronounsSettings newPronounsSettings) {
        return sendAsync(HttpMethod.PUT, newPronounsSettings);
    }

    /**
     * Creates a PronounsSettings with a new object
     *
     * @param newPronounsSettings the object to create/update
     * @return the created PronounsSettings
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PronounsSettings put(@Nonnull final PronounsSettings newPronounsSettings) throws ClientException {
        return send(HttpMethod.PUT, newPronounsSettings);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public PronounsSettingsRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public PronounsSettingsRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

