// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.ManagedEBookAssignment;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Managed EBook Assignment Request.
 */
public class ManagedEBookAssignmentRequest extends BaseRequest<ManagedEBookAssignment> {
	
    /**
     * The request for the ManagedEBookAssignment
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param responseClass  the class of the response
     */
    public ManagedEBookAssignmentRequest(@Nonnull final String requestUrl,
            @Nonnull final IBaseClient<?> client,
            @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions,
            @Nonnull final Class<? extends ManagedEBookAssignment> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * The request for the ManagedEBookAssignment
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ManagedEBookAssignmentRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, ManagedEBookAssignment.class);
    }

    /**
     * Gets the ManagedEBookAssignment from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ManagedEBookAssignment> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the ManagedEBookAssignment from the service
     *
     * @return the ManagedEBookAssignment from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ManagedEBookAssignment get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ManagedEBookAssignment> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public ManagedEBookAssignment delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this ManagedEBookAssignment with a source
     *
     * @param sourceManagedEBookAssignment the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ManagedEBookAssignment> patchAsync(@Nonnull final ManagedEBookAssignment sourceManagedEBookAssignment) {
        return sendAsync(HttpMethod.PATCH, sourceManagedEBookAssignment);
    }

    /**
     * Patches this ManagedEBookAssignment with a source
     *
     * @param sourceManagedEBookAssignment the source object with updates
     * @return the updated ManagedEBookAssignment
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ManagedEBookAssignment patch(@Nonnull final ManagedEBookAssignment sourceManagedEBookAssignment) throws ClientException {
        return send(HttpMethod.PATCH, sourceManagedEBookAssignment);
    }

    /**
     * Creates a ManagedEBookAssignment with a new object
     *
     * @param newManagedEBookAssignment the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ManagedEBookAssignment> postAsync(@Nonnull final ManagedEBookAssignment newManagedEBookAssignment) {
        return sendAsync(HttpMethod.POST, newManagedEBookAssignment);
    }

    /**
     * Creates a ManagedEBookAssignment with a new object
     *
     * @param newManagedEBookAssignment the new object to create
     * @return the created ManagedEBookAssignment
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ManagedEBookAssignment post(@Nonnull final ManagedEBookAssignment newManagedEBookAssignment) throws ClientException {
        return send(HttpMethod.POST, newManagedEBookAssignment);
    }

    /**
     * Creates a ManagedEBookAssignment with a new object
     *
     * @param newManagedEBookAssignment the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ManagedEBookAssignment> putAsync(@Nonnull final ManagedEBookAssignment newManagedEBookAssignment) {
        return sendAsync(HttpMethod.PUT, newManagedEBookAssignment);
    }

    /**
     * Creates a ManagedEBookAssignment with a new object
     *
     * @param newManagedEBookAssignment the object to create/update
     * @return the created ManagedEBookAssignment
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ManagedEBookAssignment put(@Nonnull final ManagedEBookAssignment newManagedEBookAssignment) throws ClientException {
        return send(HttpMethod.PUT, newManagedEBookAssignment);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public ManagedEBookAssignmentRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public ManagedEBookAssignmentRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

