// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.EducationFeedbackResourceOutcome;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Education Feedback Resource Outcome Request.
 */
public class EducationFeedbackResourceOutcomeRequest extends BaseRequest<EducationFeedbackResourceOutcome> {
	
    /**
     * The request for the EducationFeedbackResourceOutcome
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public EducationFeedbackResourceOutcomeRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, EducationFeedbackResourceOutcome.class);
    }

    /**
     * Gets the EducationFeedbackResourceOutcome from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EducationFeedbackResourceOutcome> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the EducationFeedbackResourceOutcome from the service
     *
     * @return the EducationFeedbackResourceOutcome from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EducationFeedbackResourceOutcome get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EducationFeedbackResourceOutcome> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public EducationFeedbackResourceOutcome delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this EducationFeedbackResourceOutcome with a source
     *
     * @param sourceEducationFeedbackResourceOutcome the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EducationFeedbackResourceOutcome> patchAsync(@Nonnull final EducationFeedbackResourceOutcome sourceEducationFeedbackResourceOutcome) {
        return sendAsync(HttpMethod.PATCH, sourceEducationFeedbackResourceOutcome);
    }

    /**
     * Patches this EducationFeedbackResourceOutcome with a source
     *
     * @param sourceEducationFeedbackResourceOutcome the source object with updates
     * @return the updated EducationFeedbackResourceOutcome
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EducationFeedbackResourceOutcome patch(@Nonnull final EducationFeedbackResourceOutcome sourceEducationFeedbackResourceOutcome) throws ClientException {
        return send(HttpMethod.PATCH, sourceEducationFeedbackResourceOutcome);
    }

    /**
     * Creates a EducationFeedbackResourceOutcome with a new object
     *
     * @param newEducationFeedbackResourceOutcome the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EducationFeedbackResourceOutcome> postAsync(@Nonnull final EducationFeedbackResourceOutcome newEducationFeedbackResourceOutcome) {
        return sendAsync(HttpMethod.POST, newEducationFeedbackResourceOutcome);
    }

    /**
     * Creates a EducationFeedbackResourceOutcome with a new object
     *
     * @param newEducationFeedbackResourceOutcome the new object to create
     * @return the created EducationFeedbackResourceOutcome
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EducationFeedbackResourceOutcome post(@Nonnull final EducationFeedbackResourceOutcome newEducationFeedbackResourceOutcome) throws ClientException {
        return send(HttpMethod.POST, newEducationFeedbackResourceOutcome);
    }

    /**
     * Creates a EducationFeedbackResourceOutcome with a new object
     *
     * @param newEducationFeedbackResourceOutcome the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EducationFeedbackResourceOutcome> putAsync(@Nonnull final EducationFeedbackResourceOutcome newEducationFeedbackResourceOutcome) {
        return sendAsync(HttpMethod.PUT, newEducationFeedbackResourceOutcome);
    }

    /**
     * Creates a EducationFeedbackResourceOutcome with a new object
     *
     * @param newEducationFeedbackResourceOutcome the object to create/update
     * @return the created EducationFeedbackResourceOutcome
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EducationFeedbackResourceOutcome put(@Nonnull final EducationFeedbackResourceOutcome newEducationFeedbackResourceOutcome) throws ClientException {
        return send(HttpMethod.PUT, newEducationFeedbackResourceOutcome);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public EducationFeedbackResourceOutcomeRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public EducationFeedbackResourceOutcomeRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

