// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.VirtualEventWebinar;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Virtual Event Webinar Get By User Role Parameter Set.
 */
public class VirtualEventWebinarGetByUserRoleParameterSet {
    /**
     * The role.
     * 
     */
    @SerializedName(value = "role", alternate = {"Role"})
    @Expose
	@Nullable
    public String role;


    /**
     * Instiaciates a new VirtualEventWebinarGetByUserRoleParameterSet
     */
    public VirtualEventWebinarGetByUserRoleParameterSet() {}
    /**
     * Instiaciates a new VirtualEventWebinarGetByUserRoleParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected VirtualEventWebinarGetByUserRoleParameterSet(@Nonnull final VirtualEventWebinarGetByUserRoleParameterSetBuilder builder) {
        this.role = builder.role;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static VirtualEventWebinarGetByUserRoleParameterSetBuilder newBuilder() {
        return new VirtualEventWebinarGetByUserRoleParameterSetBuilder();
    }
    /**
     * Fluent builder for the VirtualEventWebinarGetByUserRoleParameterSet
     */
    public static final class VirtualEventWebinarGetByUserRoleParameterSetBuilder {
        /**
         * The role parameter value
         */
        @Nullable
        protected String role;
        /**
         * Sets the Role
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public VirtualEventWebinarGetByUserRoleParameterSetBuilder withRole(@Nullable final String val) {
            this.role = val;
            return this;
        }
        /**
         * Instanciates a new VirtualEventWebinarGetByUserRoleParameterSetBuilder
         */
        @Nullable
        protected VirtualEventWebinarGetByUserRoleParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public VirtualEventWebinarGetByUserRoleParameterSet build() {
            return new VirtualEventWebinarGetByUserRoleParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.role != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("role", role));
        }
        return result;
    }
}
