// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.UserExperienceAnalyticsCategory;
import com.microsoft.graph.models.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the User Experience Analytics Baseline.
 */
public class UserExperienceAnalyticsBaseline extends Entity implements IJsonBackedObject {


    /**
     * The Created Date Time.
     * The date the custom baseline was created. The value cannot be modified and is automatically populated when the baseline is created. The Timestamp type represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this: '2014-01-01T00:00:00Z'. Returned by default.
     */
    @SerializedName(value = "createdDateTime", alternate = {"CreatedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime createdDateTime;

    /**
     * The Display Name.
     * The name of the baseline.
     */
    @SerializedName(value = "displayName", alternate = {"DisplayName"})
    @Expose
	@Nullable
    public String displayName;

    /**
     * The Is Built In.
     * When TRUE, indicates the current baseline is the commercial median baseline. When FALSE, indicates it is a custom baseline. FALSE by default.
     */
    @SerializedName(value = "isBuiltIn", alternate = {"IsBuiltIn"})
    @Expose
	@Nullable
    public Boolean isBuiltIn;

    /**
     * The App Health Metrics.
     * The scores and insights for the application health metrics.
     */
    @SerializedName(value = "appHealthMetrics", alternate = {"AppHealthMetrics"})
    @Expose
	@Nullable
    public UserExperienceAnalyticsCategory appHealthMetrics;

    /**
     * The Battery Health Metrics.
     * The scores and insights for the battery health metrics.
     */
    @SerializedName(value = "batteryHealthMetrics", alternate = {"BatteryHealthMetrics"})
    @Expose
	@Nullable
    public UserExperienceAnalyticsCategory batteryHealthMetrics;

    /**
     * The Best Practices Metrics.
     * The scores and insights for the best practices metrics.
     */
    @SerializedName(value = "bestPracticesMetrics", alternate = {"BestPracticesMetrics"})
    @Expose
	@Nullable
    public UserExperienceAnalyticsCategory bestPracticesMetrics;

    /**
     * The Device Boot Performance Metrics.
     * The scores and insights for the device boot performance metrics.
     */
    @SerializedName(value = "deviceBootPerformanceMetrics", alternate = {"DeviceBootPerformanceMetrics"})
    @Expose
	@Nullable
    public UserExperienceAnalyticsCategory deviceBootPerformanceMetrics;

    /**
     * The Reboot Analytics Metrics.
     * The scores and insights for the reboot analytics metrics.
     */
    @SerializedName(value = "rebootAnalyticsMetrics", alternate = {"RebootAnalyticsMetrics"})
    @Expose
	@Nullable
    public UserExperienceAnalyticsCategory rebootAnalyticsMetrics;

    /**
     * The Resource Performance Metrics.
     * The scores and insights for the resource performance metrics.
     */
    @SerializedName(value = "resourcePerformanceMetrics", alternate = {"ResourcePerformanceMetrics"})
    @Expose
	@Nullable
    public UserExperienceAnalyticsCategory resourcePerformanceMetrics;

    /**
     * The Work From Anywhere Metrics.
     * The scores and insights for the work from anywhere metrics.
     */
    @SerializedName(value = "workFromAnywhereMetrics", alternate = {"WorkFromAnywhereMetrics"})
    @Expose
	@Nullable
    public UserExperienceAnalyticsCategory workFromAnywhereMetrics;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
