// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Teams App Settings.
 */
public class TeamsAppSettings extends Entity implements IJsonBackedObject {


    /**
     * The Allow User Requests For App Access.
     * Indicates whether users are allowed to request access to the unavailable Teams apps.
     */
    @SerializedName(value = "allowUserRequestsForAppAccess", alternate = {"AllowUserRequestsForAppAccess"})
    @Expose
	@Nullable
    public Boolean allowUserRequestsForAppAccess;

    /**
     * The Is User Personal Scope Resource Specific Consent Enabled.
     * Indicates whether resource-specific consent for personal scope in Teams apps is enabled for the tenant. True indicates that Teams apps that are allowed in the tenant and require resource-specific permissions can be installed in the personal scope. False blocks the installation of any Teams app that requires resource-specific permissions in the personal scope.
     */
    @SerializedName(value = "isUserPersonalScopeResourceSpecificConsentEnabled", alternate = {"IsUserPersonalScopeResourceSpecificConsentEnabled"})
    @Expose
	@Nullable
    public Boolean isUserPersonalScopeResourceSpecificConsentEnabled;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
