// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.TeamsAppPermissionSet;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Teams App Installation Upgrade Parameter Set.
 */
public class TeamsAppInstallationUpgradeParameterSet {
    /**
     * The consented Permission Set.
     * 
     */
    @SerializedName(value = "consentedPermissionSet", alternate = {"ConsentedPermissionSet"})
    @Expose
	@Nullable
    public TeamsAppPermissionSet consentedPermissionSet;


    /**
     * Instiaciates a new TeamsAppInstallationUpgradeParameterSet
     */
    public TeamsAppInstallationUpgradeParameterSet() {}
    /**
     * Instiaciates a new TeamsAppInstallationUpgradeParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected TeamsAppInstallationUpgradeParameterSet(@Nonnull final TeamsAppInstallationUpgradeParameterSetBuilder builder) {
        this.consentedPermissionSet = builder.consentedPermissionSet;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static TeamsAppInstallationUpgradeParameterSetBuilder newBuilder() {
        return new TeamsAppInstallationUpgradeParameterSetBuilder();
    }
    /**
     * Fluent builder for the TeamsAppInstallationUpgradeParameterSet
     */
    public static final class TeamsAppInstallationUpgradeParameterSetBuilder {
        /**
         * The consentedPermissionSet parameter value
         */
        @Nullable
        protected TeamsAppPermissionSet consentedPermissionSet;
        /**
         * Sets the ConsentedPermissionSet
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public TeamsAppInstallationUpgradeParameterSetBuilder withConsentedPermissionSet(@Nullable final TeamsAppPermissionSet val) {
            this.consentedPermissionSet = val;
            return this;
        }
        /**
         * Instanciates a new TeamsAppInstallationUpgradeParameterSetBuilder
         */
        @Nullable
        protected TeamsAppInstallationUpgradeParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public TeamsAppInstallationUpgradeParameterSet build() {
            return new TeamsAppInstallationUpgradeParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.consentedPermissionSet != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("consentedPermissionSet", consentedPermissionSet));
        }
        return result;
    }
}
