// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.EducationItemBody;
import com.microsoft.graph.models.EducationAssignmentGradeType;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Rubric Level.
 */
public class RubricLevel implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Description.
     * The description of this rubric level.
     */
    @SerializedName(value = "description", alternate = {"Description"})
    @Expose
	@Nullable
    public EducationItemBody description;

    /**
     * The Display Name.
     * The name of this rubric level.
     */
    @SerializedName(value = "displayName", alternate = {"DisplayName"})
    @Expose
	@Nullable
    public String displayName;

    /**
     * The Grading.
     * Null if this is a no-points rubric; educationAssignmentPointsGradeType if it's a points rubric.
     */
    @SerializedName(value = "grading", alternate = {"Grading"})
    @Expose
	@Nullable
    public EducationAssignmentGradeType grading;

    /**
     * The Level Id.
     * The ID of this resource.
     */
    @SerializedName(value = "levelId", alternate = {"LevelId"})
    @Expose
	@Nullable
    public String levelId;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
