// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.MicrosoftTrainingAssignmentMapping;
import com.microsoft.graph.models.TrainingCompletionDuration;
import com.microsoft.graph.models.TrainingSetting;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Microsoft Custom Training Setting.
 */
public class MicrosoftCustomTrainingSetting extends TrainingSetting implements IJsonBackedObject {


    /**
     * The Completion Date Time.
     * The completion date and time of the training. The timestamp type represents date and time information using ISO 8601 format and is always in UTC. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z.
     */
    @SerializedName(value = "completionDateTime", alternate = {"CompletionDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime completionDateTime;

    /**
     * The Training Assignment Mappings.
     * The mapping details of the associated training.
     */
    @SerializedName(value = "trainingAssignmentMappings", alternate = {"TrainingAssignmentMappings"})
    @Expose
	@Nullable
    public java.util.List<MicrosoftTrainingAssignmentMapping> trainingAssignmentMappings;

    /**
     * The Training Completion Duration.
     * The training completion duration that needs to be provided before scheduling the training. Possible values are: week, fortnite, month, unknownFutureValue.
     */
    @SerializedName(value = "trainingCompletionDuration", alternate = {"TrainingCompletionDuration"})
    @Expose
	@Nullable
    public TrainingCompletionDuration trainingCompletionDuration;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
