// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.DirectoryDefinitionDiscoverabilities;
import com.microsoft.graph.models.ObjectDefinition;
import com.microsoft.graph.models.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Directory Definition.
 */
public class DirectoryDefinition extends Entity implements IJsonBackedObject {


    /**
     * The Discoverabilities.
     * Read-only value indicating what type of discovery the app supports. The possible values are: None, AttributeNames, AttributeDataTypes, AttributeReadOnly, ReferenceAttributes, UnknownFutureValue. This is a multi-valued object.
     */
    @SerializedName(value = "discoverabilities", alternate = {"Discoverabilities"})
    @Expose
	@Nullable
    public EnumSet<DirectoryDefinitionDiscoverabilities> discoverabilities;

    /**
     * The Discovery Date Time.
     * Represents the discovery date and time using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z.
     */
    @SerializedName(value = "discoveryDateTime", alternate = {"DiscoveryDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime discoveryDateTime;

    /**
     * The Name.
     * Name of the directory. Must be unique within the synchronization schema. Not nullable.
     */
    @SerializedName(value = "name", alternate = {"Name"})
    @Expose
	@Nullable
    public String name;

    /**
     * The Objects.
     * Collection of objects supported by the directory.
     */
    @SerializedName(value = "objects", alternate = {"Objects"})
    @Expose
	@Nullable
    public java.util.List<ObjectDefinition> objects;

    /**
     * The Read Only.
     * Whether this object is read-only.
     */
    @SerializedName(value = "readOnly", alternate = {"ReadOnly"})
    @Expose
	@Nullable
    public Boolean readOnly;

    /**
     * The Version.
     * Read only value that indicates version discovered. null if discovery hasn't yet occurred.
     */
    @SerializedName(value = "version", alternate = {"Version"})
    @Expose
	@Nullable
    public String version;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
