// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.requests.AllowedValueCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Custom Security Attribute Definition.
 */
public class CustomSecurityAttributeDefinition extends Entity implements IJsonBackedObject {


    /**
     * The Attribute Set.
     * Name of the attribute set. Case insensitive.
     */
    @SerializedName(value = "attributeSet", alternate = {"AttributeSet"})
    @Expose
	@Nullable
    public String attributeSet;

    /**
     * The Description.
     * Description of the custom security attribute. Can be up to 128 characters long and include Unicode characters. Can be changed later.
     */
    @SerializedName(value = "description", alternate = {"Description"})
    @Expose
	@Nullable
    public String description;

    /**
     * The Is Collection.
     * Indicates whether multiple values can be assigned to the custom security attribute. Cannot be changed later. If type is set to Boolean, isCollection cannot be set to true.
     */
    @SerializedName(value = "isCollection", alternate = {"IsCollection"})
    @Expose
	@Nullable
    public Boolean isCollection;

    /**
     * The Is Searchable.
     * Indicates whether custom security attribute values are indexed for searching on objects that are assigned attribute values. Cannot be changed later.
     */
    @SerializedName(value = "isSearchable", alternate = {"IsSearchable"})
    @Expose
	@Nullable
    public Boolean isSearchable;

    /**
     * The Name.
     * Name of the custom security attribute. Must be unique within an attribute set. Can be up to 32 characters long and include Unicode characters. Cannot contain spaces or special characters. Cannot be changed later. Case insensitive.
     */
    @SerializedName(value = "name", alternate = {"Name"})
    @Expose
	@Nullable
    public String name;

    /**
     * The Status.
     * Specifies whether the custom security attribute is active or deactivated. Acceptable values are: Available and Deprecated. Can be changed later.
     */
    @SerializedName(value = "status", alternate = {"Status"})
    @Expose
	@Nullable
    public String status;

    /**
     * The Type.
     * Data type for the custom security attribute values. Supported types are: Boolean, Integer, and String. Cannot be changed later.
     */
    @SerializedName(value = "type", alternate = {"Type"})
    @Expose
	@Nullable
    public String type;

    /**
     * The Use Pre Defined Values Only.
     * Indicates whether only predefined values can be assigned to the custom security attribute. If set to false, free-form values are allowed. Can later be changed from true to false, but cannot be changed from false to true. If type is set to Boolean, usePreDefinedValuesOnly cannot be set to true.
     */
    @SerializedName(value = "usePreDefinedValuesOnly", alternate = {"UsePreDefinedValuesOnly"})
    @Expose
	@Nullable
    public Boolean usePreDefinedValuesOnly;

    /**
     * The Allowed Values.
     * Values that are predefined for this custom security attribute. This navigation property is not returned by default and must be specified in an $expand query. For example, /directory/customSecurityAttributeDefinitions?$expand=allowedValues.
     */
    @SerializedName(value = "allowedValues", alternate = {"AllowedValues"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.AllowedValueCollectionPage allowedValues;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("allowedValues")) {
            allowedValues = serializer.deserializeObject(json.get("allowedValues"), com.microsoft.graph.requests.AllowedValueCollectionPage.class);
        }
    }
}
