// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.identitygovernance.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.identitygovernance.models.WorkflowTemplate;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workflow Template Request.
 */
public class WorkflowTemplateRequest extends BaseRequest<WorkflowTemplate> {
	
    /**
     * The request for the WorkflowTemplate
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public WorkflowTemplateRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, WorkflowTemplate.class);
    }

    /**
     * Gets the WorkflowTemplate from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkflowTemplate> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the WorkflowTemplate from the service
     *
     * @return the WorkflowTemplate from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WorkflowTemplate get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkflowTemplate> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public WorkflowTemplate delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this WorkflowTemplate with a source
     *
     * @param sourceWorkflowTemplate the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkflowTemplate> patchAsync(@Nonnull final WorkflowTemplate sourceWorkflowTemplate) {
        return sendAsync(HttpMethod.PATCH, sourceWorkflowTemplate);
    }

    /**
     * Patches this WorkflowTemplate with a source
     *
     * @param sourceWorkflowTemplate the source object with updates
     * @return the updated WorkflowTemplate
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WorkflowTemplate patch(@Nonnull final WorkflowTemplate sourceWorkflowTemplate) throws ClientException {
        return send(HttpMethod.PATCH, sourceWorkflowTemplate);
    }

    /**
     * Creates a WorkflowTemplate with a new object
     *
     * @param newWorkflowTemplate the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkflowTemplate> postAsync(@Nonnull final WorkflowTemplate newWorkflowTemplate) {
        return sendAsync(HttpMethod.POST, newWorkflowTemplate);
    }

    /**
     * Creates a WorkflowTemplate with a new object
     *
     * @param newWorkflowTemplate the new object to create
     * @return the created WorkflowTemplate
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WorkflowTemplate post(@Nonnull final WorkflowTemplate newWorkflowTemplate) throws ClientException {
        return send(HttpMethod.POST, newWorkflowTemplate);
    }

    /**
     * Creates a WorkflowTemplate with a new object
     *
     * @param newWorkflowTemplate the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkflowTemplate> putAsync(@Nonnull final WorkflowTemplate newWorkflowTemplate) {
        return sendAsync(HttpMethod.PUT, newWorkflowTemplate);
    }

    /**
     * Creates a WorkflowTemplate with a new object
     *
     * @param newWorkflowTemplate the object to create/update
     * @return the created WorkflowTemplate
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WorkflowTemplate put(@Nonnull final WorkflowTemplate newWorkflowTemplate) throws ClientException {
        return send(HttpMethod.PUT, newWorkflowTemplate);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public WorkflowTemplateRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public WorkflowTemplateRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

