// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.identitygovernance.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.identitygovernance.models.Workflow;
import com.microsoft.graph.models.User;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.identitygovernance.models.WorkflowActivateParameterSet;
import com.microsoft.graph.identitygovernance.models.WorkflowCreateNewVersionParameterSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workflow Request Builder.
 */
public class WorkflowRequestBuilder extends BaseRequestBuilder<Workflow> {

    /**
     * The request builder for the Workflow
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public WorkflowRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the WorkflowRequest instance
     */
    @Nonnull
    public WorkflowRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the WorkflowRequest instance
     */
    @Nonnull
    public WorkflowRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.identitygovernance.requests.WorkflowRequest(getRequestUrl(), getClient(), requestOptions);
    }



    /**
     * Gets the request builder for User
     *
     * @return the UserWithReferenceRequestBuilder instance
     */
    @Nonnull
    public com.microsoft.graph.requests.UserWithReferenceRequestBuilder createdBy() {
        return new com.microsoft.graph.requests.UserWithReferenceRequestBuilder(getRequestUrlWithAdditionalSegment("createdBy"), getClient(), null);
    }

    /**
     * Gets the request builder for User
     *
     * @return the UserWithReferenceRequestBuilder instance
     */
    @Nonnull
    public com.microsoft.graph.requests.UserWithReferenceRequestBuilder lastModifiedBy() {
        return new com.microsoft.graph.requests.UserWithReferenceRequestBuilder(getRequestUrlWithAdditionalSegment("lastModifiedBy"), getClient(), null);
    }
    /**
     *  Gets a request builder for the Task collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.identitygovernance.requests.TaskCollectionRequestBuilder tasks() {
        return new com.microsoft.graph.identitygovernance.requests.TaskCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("tasks"), getClient(), null);
    }

    /**
     * Gets a request builder for the Task item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.identitygovernance.requests.TaskRequestBuilder tasks(@Nonnull final String id) {
        return new com.microsoft.graph.identitygovernance.requests.TaskRequestBuilder(getRequestUrlWithAdditionalSegment("tasks") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the UserProcessingResult collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.identitygovernance.requests.UserProcessingResultCollectionWithReferencesRequestBuilder executionScope() {
        return new com.microsoft.graph.identitygovernance.requests.UserProcessingResultCollectionWithReferencesRequestBuilder(getRequestUrlWithAdditionalSegment("executionScope"), getClient(), null);
    }

    /**
     * Gets a request builder for the UserProcessingResult item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.identitygovernance.requests.UserProcessingResultWithReferenceRequestBuilder executionScope(@Nonnull final String id) {
        return new com.microsoft.graph.identitygovernance.requests.UserProcessingResultWithReferenceRequestBuilder(getRequestUrlWithAdditionalSegment("executionScope") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the Run collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.identitygovernance.requests.RunCollectionRequestBuilder runs() {
        return new com.microsoft.graph.identitygovernance.requests.RunCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("runs"), getClient(), null);
    }

    /**
     * Gets a request builder for the Run item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.identitygovernance.requests.RunRequestBuilder runs(@Nonnull final String id) {
        return new com.microsoft.graph.identitygovernance.requests.RunRequestBuilder(getRequestUrlWithAdditionalSegment("runs") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the TaskReport collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.identitygovernance.requests.TaskReportCollectionRequestBuilder taskReports() {
        return new com.microsoft.graph.identitygovernance.requests.TaskReportCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("taskReports"), getClient(), null);
    }

    /**
     * Gets a request builder for the TaskReport item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.identitygovernance.requests.TaskReportRequestBuilder taskReports(@Nonnull final String id) {
        return new com.microsoft.graph.identitygovernance.requests.TaskReportRequestBuilder(getRequestUrlWithAdditionalSegment("taskReports") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the UserProcessingResult collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.identitygovernance.requests.UserProcessingResultCollectionRequestBuilder userProcessingResults() {
        return new com.microsoft.graph.identitygovernance.requests.UserProcessingResultCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("userProcessingResults"), getClient(), null);
    }

    /**
     * Gets a request builder for the UserProcessingResult item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.identitygovernance.requests.UserProcessingResultRequestBuilder userProcessingResults(@Nonnull final String id) {
        return new com.microsoft.graph.identitygovernance.requests.UserProcessingResultRequestBuilder(getRequestUrlWithAdditionalSegment("userProcessingResults") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the WorkflowVersion collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.identitygovernance.requests.WorkflowVersionCollectionRequestBuilder versions() {
        return new com.microsoft.graph.identitygovernance.requests.WorkflowVersionCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("versions"), getClient(), null);
    }

    /**
     * Gets a request builder for the WorkflowVersion item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.identitygovernance.requests.WorkflowVersionRequestBuilder versions(@Nonnull final String id) {
        return new com.microsoft.graph.identitygovernance.requests.WorkflowVersionRequestBuilder(getRequestUrlWithAdditionalSegment("versions") + "/" + id, getClient(), null);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public WorkflowActivateRequestBuilder activate(@Nonnull final WorkflowActivateParameterSet parameters) {
        return new WorkflowActivateRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.identityGovernance.activate"), getClient(), null, parameters);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public WorkflowCreateNewVersionRequestBuilder createNewVersion(@Nonnull final WorkflowCreateNewVersionParameterSet parameters) {
        return new WorkflowCreateNewVersionRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.identityGovernance.createNewVersion"), getClient(), null, parameters);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     */
    @Nonnull
    public WorkflowRestoreRequestBuilder restore() {
        return new WorkflowRestoreRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.identityGovernance.restore"), getClient(), null);
    }
}
