// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.OperationStatus;
import com.microsoft.graph.models.OfferShiftRequest;
import com.microsoft.graph.models.OpenShiftChangeRequest;
import com.microsoft.graph.models.OpenShift;
import com.microsoft.graph.models.SchedulingGroup;
import com.microsoft.graph.models.Shift;
import com.microsoft.graph.models.SwapShiftsChangeRequest;
import com.microsoft.graph.models.TimeOffReason;
import com.microsoft.graph.models.TimeOffRequest;
import com.microsoft.graph.models.TimeOff;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.requests.OfferShiftRequestCollectionPage;
import com.microsoft.graph.requests.OpenShiftChangeRequestCollectionPage;
import com.microsoft.graph.requests.OpenShiftCollectionPage;
import com.microsoft.graph.requests.SchedulingGroupCollectionPage;
import com.microsoft.graph.requests.ShiftCollectionPage;
import com.microsoft.graph.requests.SwapShiftsChangeRequestCollectionPage;
import com.microsoft.graph.requests.TimeOffReasonCollectionPage;
import com.microsoft.graph.requests.TimeOffRequestCollectionPage;
import com.microsoft.graph.requests.TimeOffCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Schedule.
 */
public class Schedule extends Entity implements IJsonBackedObject {


    /**
     * The Enabled.
     * Indicates whether the schedule is enabled for the team. Required.
     */
    @SerializedName(value = "enabled", alternate = {"Enabled"})
    @Expose
	@Nullable
    public Boolean enabled;

    /**
     * The Offer Shift Requests Enabled.
     * Indicates whether offer shift requests are enabled for the schedule.
     */
    @SerializedName(value = "offerShiftRequestsEnabled", alternate = {"OfferShiftRequestsEnabled"})
    @Expose
	@Nullable
    public Boolean offerShiftRequestsEnabled;

    /**
     * The Open Shifts Enabled.
     * Indicates whether open shifts are enabled for the schedule.
     */
    @SerializedName(value = "openShiftsEnabled", alternate = {"OpenShiftsEnabled"})
    @Expose
	@Nullable
    public Boolean openShiftsEnabled;

    /**
     * The Provision Status.
     * The status of the schedule provisioning. The possible values are notStarted, running, completed, failed.
     */
    @SerializedName(value = "provisionStatus", alternate = {"ProvisionStatus"})
    @Expose
	@Nullable
    public OperationStatus provisionStatus;

    /**
     * The Provision Status Code.
     * Additional information about why schedule provisioning failed.
     */
    @SerializedName(value = "provisionStatusCode", alternate = {"ProvisionStatusCode"})
    @Expose
	@Nullable
    public String provisionStatusCode;

    /**
     * The Swap Shifts Requests Enabled.
     * Indicates whether swap shifts requests are enabled for the schedule.
     */
    @SerializedName(value = "swapShiftsRequestsEnabled", alternate = {"SwapShiftsRequestsEnabled"})
    @Expose
	@Nullable
    public Boolean swapShiftsRequestsEnabled;

    /**
     * The Time Clock Enabled.
     * Indicates whether time clock is enabled for the schedule.
     */
    @SerializedName(value = "timeClockEnabled", alternate = {"TimeClockEnabled"})
    @Expose
	@Nullable
    public Boolean timeClockEnabled;

    /**
     * The Time Off Requests Enabled.
     * Indicates whether time off requests are enabled for the schedule.
     */
    @SerializedName(value = "timeOffRequestsEnabled", alternate = {"TimeOffRequestsEnabled"})
    @Expose
	@Nullable
    public Boolean timeOffRequestsEnabled;

    /**
     * The Time Zone.
     * Indicates the time zone of the schedule team using tz database format. Required.
     */
    @SerializedName(value = "timeZone", alternate = {"TimeZone"})
    @Expose
	@Nullable
    public String timeZone;

    /**
     * The Workforce Integration Ids.
     * 
     */
    @SerializedName(value = "workforceIntegrationIds", alternate = {"WorkforceIntegrationIds"})
    @Expose
	@Nullable
    public java.util.List<String> workforceIntegrationIds;

    /**
     * The Offer Shift Requests.
     * 
     */
    @SerializedName(value = "offerShiftRequests", alternate = {"OfferShiftRequests"})
    @Expose
	@Nullable
    public OfferShiftRequestCollectionPage offerShiftRequests;

    /**
     * The Open Shift Change Requests.
     * 
     */
    @SerializedName(value = "openShiftChangeRequests", alternate = {"OpenShiftChangeRequests"})
    @Expose
	@Nullable
    public OpenShiftChangeRequestCollectionPage openShiftChangeRequests;

    /**
     * The Open Shifts.
     * 
     */
    @SerializedName(value = "openShifts", alternate = {"OpenShifts"})
    @Expose
	@Nullable
    public OpenShiftCollectionPage openShifts;

    /**
     * The Scheduling Groups.
     * The logical grouping of users in the schedule (usually by role).
     */
    @SerializedName(value = "schedulingGroups", alternate = {"SchedulingGroups"})
    @Expose
	@Nullable
    public SchedulingGroupCollectionPage schedulingGroups;

    /**
     * The Shifts.
     * The shifts in the schedule.
     */
    @SerializedName(value = "shifts", alternate = {"Shifts"})
    @Expose
	@Nullable
    public ShiftCollectionPage shifts;

    /**
     * The Swap Shifts Change Requests.
     * 
     */
    @SerializedName(value = "swapShiftsChangeRequests", alternate = {"SwapShiftsChangeRequests"})
    @Expose
	@Nullable
    public SwapShiftsChangeRequestCollectionPage swapShiftsChangeRequests;

    /**
     * The Time Off Reasons.
     * The set of reasons for a time off in the schedule.
     */
    @SerializedName(value = "timeOffReasons", alternate = {"TimeOffReasons"})
    @Expose
	@Nullable
    public TimeOffReasonCollectionPage timeOffReasons;

    /**
     * The Time Off Requests.
     * 
     */
    @SerializedName(value = "timeOffRequests", alternate = {"TimeOffRequests"})
    @Expose
	@Nullable
    public TimeOffRequestCollectionPage timeOffRequests;

    /**
     * The Times Off.
     * The instances of times off in the schedule.
     */
    @SerializedName(value = "timesOff", alternate = {"TimesOff"})
    @Expose
	@Nullable
    public TimeOffCollectionPage timesOff;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("offerShiftRequests")) {
            offerShiftRequests = serializer.deserializeObject(json.get("offerShiftRequests"), OfferShiftRequestCollectionPage.class);
        }

        if (json.has("openShiftChangeRequests")) {
            openShiftChangeRequests = serializer.deserializeObject(json.get("openShiftChangeRequests"), OpenShiftChangeRequestCollectionPage.class);
        }

        if (json.has("openShifts")) {
            openShifts = serializer.deserializeObject(json.get("openShifts"), OpenShiftCollectionPage.class);
        }

        if (json.has("schedulingGroups")) {
            schedulingGroups = serializer.deserializeObject(json.get("schedulingGroups"), SchedulingGroupCollectionPage.class);
        }

        if (json.has("shifts")) {
            shifts = serializer.deserializeObject(json.get("shifts"), ShiftCollectionPage.class);
        }

        if (json.has("swapShiftsChangeRequests")) {
            swapShiftsChangeRequests = serializer.deserializeObject(json.get("swapShiftsChangeRequests"), SwapShiftsChangeRequestCollectionPage.class);
        }

        if (json.has("timeOffReasons")) {
            timeOffReasons = serializer.deserializeObject(json.get("timeOffReasons"), TimeOffReasonCollectionPage.class);
        }

        if (json.has("timeOffRequests")) {
            timeOffRequests = serializer.deserializeObject(json.get("timeOffRequests"), TimeOffRequestCollectionPage.class);
        }

        if (json.has("timesOff")) {
            timesOff = serializer.deserializeObject(json.get("timesOff"), TimeOffCollectionPage.class);
        }
    }
}
