// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.TeamInfo;
import com.microsoft.graph.requests.ConversationMemberCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Shared With Channel Team Info.
 */
public class SharedWithChannelTeamInfo extends TeamInfo implements IJsonBackedObject {


    /**
     * The Is Host Team.
     * Indicates whether the team is the host of the channel.
     */
    @SerializedName(value = "isHostTeam", alternate = {"IsHostTeam"})
    @Expose
	@Nullable
    public Boolean isHostTeam;

    /**
     * The Allowed Members.
     * A collection of team members who have access to the shared channel.
     */
	@Nullable
    public com.microsoft.graph.requests.ConversationMemberCollectionPage allowedMembers;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("allowedMembers")) {
            allowedMembers = serializer.deserializeObject(json.get("allowedMembers"), com.microsoft.graph.requests.ConversationMemberCollectionPage.class);
        }
    }
}
