// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.PronounsSettings;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.requests.ProfileCardPropertyCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the People Admin Settings.
 */
public class PeopleAdminSettings extends Entity implements IJsonBackedObject {


    /**
     * The Profile Card Properties.
     * Contains a collection of the properties an administrator has defined as visible on the Microsoft 365 profile card.
     */
    @SerializedName(value = "profileCardProperties", alternate = {"ProfileCardProperties"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.ProfileCardPropertyCollectionPage profileCardProperties;

    /**
     * The Pronouns.
     * Represents administrator settings that manage the support of pronouns in an organization.
     */
    @SerializedName(value = "pronouns", alternate = {"Pronouns"})
    @Expose
	@Nullable
    public PronounsSettings pronouns;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("profileCardProperties")) {
            profileCardProperties = serializer.deserializeObject(json.get("profileCardProperties"), com.microsoft.graph.requests.ProfileCardPropertyCollectionPage.class);
        }
    }
}
