// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.CustomExtensionEndpointConfiguration;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Logic App Trigger Endpoint Configuration.
 */
public class LogicAppTriggerEndpointConfiguration extends CustomExtensionEndpointConfiguration implements IJsonBackedObject {


    /**
     * The Logic App Workflow Name.
     * The name of the logic app.
     */
    @SerializedName(value = "logicAppWorkflowName", alternate = {"LogicAppWorkflowName"})
    @Expose
	@Nullable
    public String logicAppWorkflowName;

    /**
     * The Resource Group Name.
     * The Azure resource group name for the logic app.
     */
    @SerializedName(value = "resourceGroupName", alternate = {"ResourceGroupName"})
    @Expose
	@Nullable
    public String resourceGroupName;

    /**
     * The Subscription Id.
     * Identifier of the Azure subscription for the logic app.
     */
    @SerializedName(value = "subscriptionId", alternate = {"SubscriptionId"})
    @Expose
	@Nullable
    public String subscriptionId;

    /**
     * The Url.
     * The URL to the logic app endpoint that will be triggered. Only required for app-only token scenarios where app is creating a customCalloutExtension without a signed-in user.
     */
    @SerializedName(value = "url", alternate = {"Url"})
    @Expose
	@Nullable
    public String url;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
