// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.AccessPackageCustomExtensionStage;
import com.microsoft.graph.models.CustomCalloutExtension;
import com.microsoft.graph.models.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Custom Extension Stage Setting.
 */
public class CustomExtensionStageSetting extends Entity implements IJsonBackedObject {


    /**
     * The Stage.
     * Indicates the stage of the access package assignment request workflow when the access package custom extension runs. The possible values are: assignmentRequestCreated, assignmentRequestApproved, assignmentRequestGranted, assignmentRequestRemoved, assignmentFourteenDaysBeforeExpiration, assignmentOneDayBeforeExpiration, unknownFutureValue.
     */
    @SerializedName(value = "stage", alternate = {"Stage"})
    @Expose
	@Nullable
    public AccessPackageCustomExtensionStage stage;

    /**
     * The Custom Extension.
     * Indicates the custom workflow extension that will be executed at this stage. Nullable. Supports $expand.
     */
    @SerializedName(value = "customExtension", alternate = {"CustomExtension"})
    @Expose
	@Nullable
    public CustomCalloutExtension customExtension;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
