// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.security.models.Vulnerability;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Vulnerability Request Builder.
 */
public class VulnerabilityRequestBuilder extends BaseRequestBuilder<Vulnerability> {

    /**
     * The request builder for the Vulnerability
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public VulnerabilityRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the VulnerabilityRequest instance
     */
    @Nonnull
    public VulnerabilityRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the VulnerabilityRequest instance
     */
    @Nonnull
    public VulnerabilityRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.security.requests.VulnerabilityRequest(getRequestUrl(), getClient(), requestOptions);
    }


    /**
     *  Gets a request builder for the Article collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.security.requests.ArticleCollectionWithReferencesRequestBuilder articles() {
        return new com.microsoft.graph.security.requests.ArticleCollectionWithReferencesRequestBuilder(getRequestUrlWithAdditionalSegment("articles"), getClient(), null);
    }

    /**
     * Gets a request builder for the Article item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.security.requests.ArticleWithReferenceRequestBuilder articles(@Nonnull final String id) {
        return new com.microsoft.graph.security.requests.ArticleWithReferenceRequestBuilder(getRequestUrlWithAdditionalSegment("articles") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the VulnerabilityComponent collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.security.requests.VulnerabilityComponentCollectionRequestBuilder components() {
        return new com.microsoft.graph.security.requests.VulnerabilityComponentCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("components"), getClient(), null);
    }

    /**
     * Gets a request builder for the VulnerabilityComponent item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.security.requests.VulnerabilityComponentRequestBuilder components(@Nonnull final String id) {
        return new com.microsoft.graph.security.requests.VulnerabilityComponentRequestBuilder(getRequestUrlWithAdditionalSegment("components") + "/" + id, getClient(), null);
    }
}
