// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.security.models.ThreatIntelligence;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Threat Intelligence Request.
 */
public class ThreatIntelligenceRequest extends BaseRequest<ThreatIntelligence> {
	
    /**
     * The request for the ThreatIntelligence
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ThreatIntelligenceRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, ThreatIntelligence.class);
    }

    /**
     * Gets the ThreatIntelligence from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ThreatIntelligence> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the ThreatIntelligence from the service
     *
     * @return the ThreatIntelligence from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ThreatIntelligence get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ThreatIntelligence> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public ThreatIntelligence delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this ThreatIntelligence with a source
     *
     * @param sourceThreatIntelligence the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ThreatIntelligence> patchAsync(@Nonnull final ThreatIntelligence sourceThreatIntelligence) {
        return sendAsync(HttpMethod.PATCH, sourceThreatIntelligence);
    }

    /**
     * Patches this ThreatIntelligence with a source
     *
     * @param sourceThreatIntelligence the source object with updates
     * @return the updated ThreatIntelligence
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ThreatIntelligence patch(@Nonnull final ThreatIntelligence sourceThreatIntelligence) throws ClientException {
        return send(HttpMethod.PATCH, sourceThreatIntelligence);
    }

    /**
     * Creates a ThreatIntelligence with a new object
     *
     * @param newThreatIntelligence the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ThreatIntelligence> postAsync(@Nonnull final ThreatIntelligence newThreatIntelligence) {
        return sendAsync(HttpMethod.POST, newThreatIntelligence);
    }

    /**
     * Creates a ThreatIntelligence with a new object
     *
     * @param newThreatIntelligence the new object to create
     * @return the created ThreatIntelligence
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ThreatIntelligence post(@Nonnull final ThreatIntelligence newThreatIntelligence) throws ClientException {
        return send(HttpMethod.POST, newThreatIntelligence);
    }

    /**
     * Creates a ThreatIntelligence with a new object
     *
     * @param newThreatIntelligence the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ThreatIntelligence> putAsync(@Nonnull final ThreatIntelligence newThreatIntelligence) {
        return sendAsync(HttpMethod.PUT, newThreatIntelligence);
    }

    /**
     * Creates a ThreatIntelligence with a new object
     *
     * @param newThreatIntelligence the object to create/update
     * @return the created ThreatIntelligence
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ThreatIntelligence put(@Nonnull final ThreatIntelligence newThreatIntelligence) throws ClientException {
        return send(HttpMethod.PUT, newThreatIntelligence);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public ThreatIntelligenceRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public ThreatIntelligenceRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

