// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.security.models.SslCertificate;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Ssl Certificate Request.
 */
public class SslCertificateRequest extends BaseRequest<SslCertificate> {
	
    /**
     * The request for the SslCertificate
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public SslCertificateRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, SslCertificate.class);
    }

    /**
     * Gets the SslCertificate from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SslCertificate> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the SslCertificate from the service
     *
     * @return the SslCertificate from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SslCertificate get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SslCertificate> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public SslCertificate delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this SslCertificate with a source
     *
     * @param sourceSslCertificate the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SslCertificate> patchAsync(@Nonnull final SslCertificate sourceSslCertificate) {
        return sendAsync(HttpMethod.PATCH, sourceSslCertificate);
    }

    /**
     * Patches this SslCertificate with a source
     *
     * @param sourceSslCertificate the source object with updates
     * @return the updated SslCertificate
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SslCertificate patch(@Nonnull final SslCertificate sourceSslCertificate) throws ClientException {
        return send(HttpMethod.PATCH, sourceSslCertificate);
    }

    /**
     * Creates a SslCertificate with a new object
     *
     * @param newSslCertificate the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SslCertificate> postAsync(@Nonnull final SslCertificate newSslCertificate) {
        return sendAsync(HttpMethod.POST, newSslCertificate);
    }

    /**
     * Creates a SslCertificate with a new object
     *
     * @param newSslCertificate the new object to create
     * @return the created SslCertificate
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SslCertificate post(@Nonnull final SslCertificate newSslCertificate) throws ClientException {
        return send(HttpMethod.POST, newSslCertificate);
    }

    /**
     * Creates a SslCertificate with a new object
     *
     * @param newSslCertificate the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SslCertificate> putAsync(@Nonnull final SslCertificate newSslCertificate) {
        return sendAsync(HttpMethod.PUT, newSslCertificate);
    }

    /**
     * Creates a SslCertificate with a new object
     *
     * @param newSslCertificate the object to create/update
     * @return the created SslCertificate
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SslCertificate put(@Nonnull final SslCertificate newSslCertificate) throws ClientException {
        return send(HttpMethod.PUT, newSslCertificate);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public SslCertificateRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public SslCertificateRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

