// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.security.models.Article;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Article Request.
 */
public class ArticleRequest extends BaseRequest<Article> {
	
    /**
     * The request for the Article
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ArticleRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, Article.class);
    }

    /**
     * Gets the Article from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Article> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the Article from the service
     *
     * @return the Article from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Article get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Article> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public Article delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this Article with a source
     *
     * @param sourceArticle the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Article> patchAsync(@Nonnull final Article sourceArticle) {
        return sendAsync(HttpMethod.PATCH, sourceArticle);
    }

    /**
     * Patches this Article with a source
     *
     * @param sourceArticle the source object with updates
     * @return the updated Article
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Article patch(@Nonnull final Article sourceArticle) throws ClientException {
        return send(HttpMethod.PATCH, sourceArticle);
    }

    /**
     * Creates a Article with a new object
     *
     * @param newArticle the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Article> postAsync(@Nonnull final Article newArticle) {
        return sendAsync(HttpMethod.POST, newArticle);
    }

    /**
     * Creates a Article with a new object
     *
     * @param newArticle the new object to create
     * @return the created Article
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Article post(@Nonnull final Article newArticle) throws ClientException {
        return send(HttpMethod.POST, newArticle);
    }

    /**
     * Creates a Article with a new object
     *
     * @param newArticle the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Article> putAsync(@Nonnull final Article newArticle) {
        return sendAsync(HttpMethod.PUT, newArticle);
    }

    /**
     * Creates a Article with a new object
     *
     * @param newArticle the object to create/update
     * @return the created Article
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Article put(@Nonnull final Article newArticle) throws ClientException {
        return send(HttpMethod.PUT, newArticle);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public ArticleRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public ArticleRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

