// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.PhysicalAddress;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Ssl Certificate Entity.
 */
public class SslCertificateEntity implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Address.
     * A physical address of the entity.
     */
    @SerializedName(value = "address", alternate = {"Address"})
    @Expose
	@Nullable
    public PhysicalAddress address;

    /**
     * The Alternate Names.
     * Alternate names for this entity that are part of the certificate.
     */
    @SerializedName(value = "alternateNames", alternate = {"AlternateNames"})
    @Expose
	@Nullable
    public java.util.List<String> alternateNames;

    /**
     * The Common Name.
     * A common name for this entity.
     */
    @SerializedName(value = "commonName", alternate = {"CommonName"})
    @Expose
	@Nullable
    public String commonName;

    /**
     * The Email.
     * An email for this entity.
     */
    @SerializedName(value = "email", alternate = {"Email"})
    @Expose
	@Nullable
    public String email;

    /**
     * The Given Name.
     * If the entity is a person, this is the person's given name (first name).
     */
    @SerializedName(value = "givenName", alternate = {"GivenName"})
    @Expose
	@Nullable
    public String givenName;

    /**
     * The Organization Name.
     * If the entity is an organization, this is the name of the organization.
     */
    @SerializedName(value = "organizationName", alternate = {"OrganizationName"})
    @Expose
	@Nullable
    public String organizationName;

    /**
     * The Organization Unit Name.
     * If the entity is an organization, this communicates if a unit in the organization is named on the entity.
     */
    @SerializedName(value = "organizationUnitName", alternate = {"OrganizationUnitName"})
    @Expose
	@Nullable
    public String organizationUnitName;

    /**
     * The Serial Number.
     * A serial number assigned to the entity; usually only available if the entity is the issuer.
     */
    @SerializedName(value = "serialNumber", alternate = {"SerialNumber"})
    @Expose
	@Nullable
    public String serialNumber;

    /**
     * The Surname.
     * If the entity is a person, this is the person's surname (last name).
     */
    @SerializedName(value = "surname", alternate = {"Surname"})
    @Expose
	@Nullable
    public String surname;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
