// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.security.models.DetectionStatus;
import com.microsoft.graph.security.models.FileDetails;
import com.microsoft.graph.security.models.UserAccount;
import com.microsoft.graph.security.models.AlertEvidence;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Process Evidence.
 */
public class ProcessEvidence extends AlertEvidence implements IJsonBackedObject {


    /**
     * The Detection Status.
     * The status of the detection.The possible values are: detected, blocked, prevented, unknownFutureValue.
     */
    @SerializedName(value = "detectionStatus", alternate = {"DetectionStatus"})
    @Expose
	@Nullable
    public DetectionStatus detectionStatus;

    /**
     * The Image File.
     * Image file details.
     */
    @SerializedName(value = "imageFile", alternate = {"ImageFile"})
    @Expose
	@Nullable
    public FileDetails imageFile;

    /**
     * The Mde Device Id.
     * A unique identifier assigned to a device by Microsoft Defender for Endpoint.
     */
    @SerializedName(value = "mdeDeviceId", alternate = {"MdeDeviceId"})
    @Expose
	@Nullable
    public String mdeDeviceId;

    /**
     * The Parent Process Creation Date Time.
     * Date and time when the parent of the process was created. The DateTimeOffset type represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z.
     */
    @SerializedName(value = "parentProcessCreationDateTime", alternate = {"ParentProcessCreationDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime parentProcessCreationDateTime;

    /**
     * The Parent Process Id.
     * Process ID (PID) of the parent process that spawned the process.
     */
    @SerializedName(value = "parentProcessId", alternate = {"ParentProcessId"})
    @Expose
	@Nullable
    public Long parentProcessId;

    /**
     * The Parent Process Image File.
     * Parent process image file details.
     */
    @SerializedName(value = "parentProcessImageFile", alternate = {"ParentProcessImageFile"})
    @Expose
	@Nullable
    public FileDetails parentProcessImageFile;

    /**
     * The Process Command Line.
     * Command line used to create the new process.
     */
    @SerializedName(value = "processCommandLine", alternate = {"ProcessCommandLine"})
    @Expose
	@Nullable
    public String processCommandLine;

    /**
     * The Process Creation Date Time.
     * Date and time when the process was created. The DateTimeOffset type represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z.
     */
    @SerializedName(value = "processCreationDateTime", alternate = {"ProcessCreationDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime processCreationDateTime;

    /**
     * The Process Id.
     * Process ID (PID) of the newly created process.
     */
    @SerializedName(value = "processId", alternate = {"ProcessId"})
    @Expose
	@Nullable
    public Long processId;

    /**
     * The User Account.
     * User details of the user that ran the process.
     */
    @SerializedName(value = "userAccount", alternate = {"UserAccount"})
    @Expose
	@Nullable
    public UserAccount userAccount;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
