// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.security.models.ContainerEvidence;
import com.microsoft.graph.security.models.KubernetesControllerEvidence;
import com.microsoft.graph.security.models.Dictionary;
import com.microsoft.graph.security.models.KubernetesNamespaceEvidence;
import com.microsoft.graph.security.models.IpEvidence;
import com.microsoft.graph.security.models.KubernetesServiceAccountEvidence;
import com.microsoft.graph.security.models.AlertEvidence;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Kubernetes Pod Evidence.
 */
public class KubernetesPodEvidence extends AlertEvidence implements IJsonBackedObject {


    /**
     * The Containers.
     * The list of pod containers which are not init or ephemeral containers.
     */
    @SerializedName(value = "containers", alternate = {"Containers"})
    @Expose
	@Nullable
    public java.util.List<ContainerEvidence> containers;

    /**
     * The Controller.
     * The pod controller.
     */
    @SerializedName(value = "controller", alternate = {"Controller"})
    @Expose
	@Nullable
    public KubernetesControllerEvidence controller;

    /**
     * The Ephemeral Containers.
     * The list of pod ephemeral containers.
     */
    @SerializedName(value = "ephemeralContainers", alternate = {"EphemeralContainers"})
    @Expose
	@Nullable
    public java.util.List<ContainerEvidence> ephemeralContainers;

    /**
     * The Init Containers.
     * The list of pod init containers.
     */
    @SerializedName(value = "initContainers", alternate = {"InitContainers"})
    @Expose
	@Nullable
    public java.util.List<ContainerEvidence> initContainers;

    /**
     * The Labels.
     * The pod labels.
     */
    @SerializedName(value = "labels", alternate = {"Labels"})
    @Expose
	@Nullable
    public Dictionary labels;

    /**
     * The Name.
     * The pod name.
     */
    @SerializedName(value = "name", alternate = {"Name"})
    @Expose
	@Nullable
    public String name;

    /**
     * The Namespace.
     * The pod namespace.
     */
    @SerializedName(value = "namespace", alternate = {"Namespace"})
    @Expose
	@Nullable
    public KubernetesNamespaceEvidence namespace;

    /**
     * The Pod Ip.
     * The pod IP.
     */
    @SerializedName(value = "podIp", alternate = {"PodIp"})
    @Expose
	@Nullable
    public IpEvidence podIp;

    /**
     * The Service Account.
     * The pod service account.
     */
    @SerializedName(value = "serviceAccount", alternate = {"ServiceAccount"})
    @Expose
	@Nullable
    public KubernetesServiceAccountEvidence serviceAccount;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
