// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.security.models.IntelligenceProfileCountryOrRegionOfOrigin;
import com.microsoft.graph.security.models.FormattedContent;
import com.microsoft.graph.security.models.IntelligenceProfileKind;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.security.requests.IntelligenceProfileIndicatorCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Intelligence Profile.
 */
public class IntelligenceProfile extends Entity implements IJsonBackedObject {


    /**
     * The Aliases.
     * A list of commonly-known aliases for the threat intelligence included in the intelligenceProfile.
     */
    @SerializedName(value = "aliases", alternate = {"Aliases"})
    @Expose
	@Nullable
    public java.util.List<String> aliases;

    /**
     * The Countries Or Regions Of Origin.
     * The country/region of origin for the given actor or threat associated with this intelligenceProfile.
     */
    @SerializedName(value = "countriesOrRegionsOfOrigin", alternate = {"CountriesOrRegionsOfOrigin"})
    @Expose
	@Nullable
    public java.util.List<IntelligenceProfileCountryOrRegionOfOrigin> countriesOrRegionsOfOrigin;

    /**
     * The Description.
     * A synopsis of the threat actor. This property places the threat actor in wider context, tracing its discovery, history, significant campaigns, targeting, techniques of note, affiliations with governments, law enforcement countermeasures, and any areas of dispute among the security community regarding attribution.
     */
    @SerializedName(value = "description", alternate = {"Description"})
    @Expose
	@Nullable
    public FormattedContent description;

    /**
     * The First Active Date Time.
     * The date and time when this intelligenceProfile was first active. The timestamp type represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z.
     */
    @SerializedName(value = "firstActiveDateTime", alternate = {"FirstActiveDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime firstActiveDateTime;

    /**
     * The Kind.
     * A categorization of the type of this intelligenceProfile. The possible values are: actor, tool, unknownFutureValue.
     */
    @SerializedName(value = "kind", alternate = {"Kind"})
    @Expose
	@Nullable
    public IntelligenceProfileKind kind;

    /**
     * The Summary.
     * A short summary of this intelligenceProfile.
     */
    @SerializedName(value = "summary", alternate = {"Summary"})
    @Expose
	@Nullable
    public FormattedContent summary;

    /**
     * The Targets.
     * Known targets related to this intelligenceProfile.
     */
    @SerializedName(value = "targets", alternate = {"Targets"})
    @Expose
	@Nullable
    public java.util.List<String> targets;

    /**
     * The Title.
     * The title of this intelligenceProfile.
     */
    @SerializedName(value = "title", alternate = {"Title"})
    @Expose
	@Nullable
    public String title;

    /**
     * The Tradecraft.
     * Formatted information featuring a description of the distinctive tactics, techniques, and procedures (TTP) of the group, followed by a list of all known custom, commodity, and publicly available implants used by the group.
     */
    @SerializedName(value = "tradecraft", alternate = {"Tradecraft"})
    @Expose
	@Nullable
    public FormattedContent tradecraft;

    /**
     * The Indicators.
     * Includes an assemblage of high-fidelity network indicators of compromise.
     */
	@Nullable
    public com.microsoft.graph.security.requests.IntelligenceProfileIndicatorCollectionPage indicators;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("indicators")) {
            indicators = serializer.deserializeObject(json.get("indicators"), com.microsoft.graph.security.requests.IntelligenceProfileIndicatorCollectionPage.class);
        }
    }
}
