// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.security.models.HostSslCertificatePort;
import com.microsoft.graph.security.models.Host;
import com.microsoft.graph.security.models.SslCertificate;
import com.microsoft.graph.security.models.Artifact;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Host Ssl Certificate.
 */
public class HostSslCertificate extends Artifact implements IJsonBackedObject {


    /**
     * The First Seen Date Time.
     * The first date and time when this hostSslCertificate was observed. The timestamp type represents date and time information using ISO 8601 format and is always in UTC. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z.
     */
    @SerializedName(value = "firstSeenDateTime", alternate = {"FirstSeenDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime firstSeenDateTime;

    /**
     * The Last Seen Date Time.
     * The most recent date and time when this hostSslCertificate was observed. The timestamp type represents date and time information using ISO 8601 format and is always in UTC. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z.
     */
    @SerializedName(value = "lastSeenDateTime", alternate = {"LastSeenDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime lastSeenDateTime;

    /**
     * The Ports.
     * The ports related with this hostSslCertificate.
     */
    @SerializedName(value = "ports", alternate = {"Ports"})
    @Expose
	@Nullable
    public java.util.List<HostSslCertificatePort> ports;

    /**
     * The Host.
     * The host for this hostSslCertificate.
     */
    @SerializedName(value = "host", alternate = {"Host"})
    @Expose
	@Nullable
    public Host host;

    /**
     * The Ssl Certificate.
     * The sslCertificate for this hostSslCertificate.
     */
    @SerializedName(value = "sslCertificate", alternate = {"SslCertificate"})
    @Expose
	@Nullable
    public SslCertificate sslCertificate;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
